package com.qiho.center.biz.process.note.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;

/**
 * Created by pengyuyun on 2018/04/02.
 */
@Component
public class MLSmsProcessImpl implements SmsProcess, InitializingBean {

    private static final Logger logger = LoggerFactory.getLogger(MLSmsProcessImpl.class);

    @Value("${meilian.sms.url}")
    private String smsUrl;

    @Value("${meilian.sms.username}")
    private String username;

    @Value("${meilian.sms.password}")
    private String passwordMd5;

    @Value("${meilian.sms.apiKey}")
    private String apiKey;

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = getStrTemplate(template, param);
        return smsSend(context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        if (smsSendByParam(template, param, mobile)) {
            return "000000";
        }
        return "300002";
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return smsSend(template.getTemplateContext(), mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        if (smsSend(template.getTemplateContext(), mobile)) {
            return "000000";
        }
        return "300002";
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.MEI_LIAN, this);
    }

    private boolean smsSend(String content, String mobile) {

        //设置美联短信平台所需参数
        Map<String, String> params = new HashMap<>();
        params.put("username", username);
        params.put("password_md5", passwordMd5);
        params.put("apikey", apiKey);
        params.put("mobile", mobile);

        //短信内容需要MD5加密
        try {
            params.put("content", URLEncoder.encode(content, "UTF-8"));
        } catch (UnsupportedEncodingException e) {
            logger.error("短信内容编码失败，content:{}", content, e);
            return Boolean.FALSE;
        }
        params.put("encode", "UTF-8");

        String respCode = "";

        try {
            //执行请求
            String resp = HttpClientUtil.sendPost(smsUrl, params);
            if (StringUtils.isNotBlank(resp)){
                String[] resps = resp.split(":");
                respCode = resps[0];

                //判断短信是否发送成功
                if (!StringUtils.equals(respCode, "success")){
                    AppLogUtil.warn(logger, "美联发送短信异常， mobile={}, content={}, resp={}", mobile, content, resp);
                }
            }
        } catch (Exception e){
            logger.error("美联发送短信失败：mobile={}", mobile, e);
        }

        return StringUtils.equals(respCode, "success");
    }

    /**
     * 美联需要组装短信模板,
     *
     * @return
     */
    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render(template.getTemplateContext(), param);
    }
}
