package com.qiho.center.biz.process.note.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by danke on 2017/9/20.
 * 云片短信服务的实现类
 */
@Component
public class YPSmsProcessImpl implements SmsProcess, InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(YPSmsProcessImpl.class);

    @Value("${yunpian.sms.url}")
    private String smsUrl;

    @Value("${yunpian.apikey}")
    private String apikey;

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = getStrTemplate(template, param);
        return smsSend(context, mobile);
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        if (smsSendByParam(template, param, mobile)) {
            return "000000";
        }
        return "300002";
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        return smsSend(template.getTemplateContext(), mobile);
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        if (smsSend(template.getTemplateContext(), mobile)) {
            return "000000";
        }
        return "300002";
    }

    private boolean smsSend(String context, String mobile) {
        Map<String, String> params = Maps.newHashMap();
        params.put("apikey", apikey);
        params.put("text", context);
        params.put("mobile", mobile);
        Integer returnCode = -1;
        try {
            String resp = HttpClientUtil.sendPost(smsUrl, params);
            if (StringUtils.isNotBlank(resp)) {
                JSONObject json = JSON.parseObject(resp);
                returnCode = json.getInteger("code");
                if (returnCode != 0) {
                    AppLogUtil.warn(LOGGER, "云片发送短信异常， mobile={}, text={}, resp={}", mobile, context, resp);
                }
            }
        } catch (Exception e) {
            LOGGER.warn("云片发送短信失败：mobile={}", mobile, e);
        }

        return returnCode == 0;
    }

    /**
     * 云片需要组装短信模板,
     *
     * @return
     */
    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render(template.getTemplateContext(), param);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.YUNPIAN, this);
    }
}
