package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.api.remoteservice.RemoteAbTestSkuService;
import com.qiho.center.biz.service.AbTestSkuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by weny.cai on 2017/10/12.
 */
@RestController
public class RemoteAbTestSkuServiceImpl implements RemoteAbTestSkuService{

    @Autowired
    AbTestSkuService abTestSkuService;

    @Override
    public void save(List<ItemSkuDto> list, AbTestSkuDto abTestSkuDto) throws BizException {
        abTestSkuService.save(list,abTestSkuDto);
    }

    @Override
    public void delete(Long id) throws BizException{
        abTestSkuService.delete(id);
    }

    @Override
    public PagenationDto<AbTestSkuDto> queryList(TestMetadataQueryParam testMetadataQueryParam) throws BizException {
        return abTestSkuService.queryList(testMetadataQueryParam);
    }

    @Override
    public AbTestSkuDto queryDetail(Long id) throws BizException {
        return abTestSkuService.queryDetail(id);
    }

    @Override
    public void syncToItemSku(Long id,Long userId) throws BizException {
        abTestSkuService.syncToItemSku(id,userId);
    }
}
