package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.remoteservice.RemoteBannerService;
import com.qiho.center.biz.service.BannerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2017-08-29 16:31
 **/
@RestController
public class RemoteBannerServiceImpl implements RemoteBannerService{

    private static final Logger LOG = LoggerFactory.getLogger(RemoteBannerServiceImpl.class);

    @Autowired
    private BannerService bannerService;

    @Override
    public DubboResult<BannerDto> getBannerById(Long id) {
        try{
            return DubboResult.successResult(bannerService.findById(id));
        } catch (Exception e){
            LOG.error("invoke RemoteBannerImpl.getBannerById failed, bannerId={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<BannerDto>> getAllBanners(String bannerType) {
        try{
            return DubboResult.successResult(bannerService.findAllBanners(bannerType));
        } catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.getAllBanners failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<BannerDto>> getValidBanners(String bannerType) {
        try{
            return DubboResult.successResult(bannerService.findValidBanners(bannerType));
        } catch (Exception e) {
            LOG.error("invoke RemoteBannerImpl.getValidBanners failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> saveBanner(BannerDto dto) {
        try{
            return DubboResult.successResult(bannerService.saveBanner(dto)>0);
        } catch (Exception e){
            LOG.error("invoke RemoteBannerImpl.saveBanner failed, bannerDto={}",dto, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteBanner(Long id) {
        try{
            return DubboResult.successResult(bannerService.deleteBanner(id)>0);
        } catch (Exception e){
            LOG.error("invoke RemoteBannerImpl.deleteBanner failed, bannerId={}",id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> sortBanner(String idList) {
        try{
            return DubboResult.successResult(bannerService.sortBanner(idList));
        } catch (Exception e){
            LOG.error("invoke RemoteBannerImpl.sortBanner failed",e);
            return DubboResult.failResult(e.getMessage());
        }
    }


    @Override
    public DubboResult<Integer> findMaxPayload() {
        try{
            return DubboResult.successResult(bannerService.findMaxPayload());
        } catch (Exception e){
            LOG.error("invoke RemoteBannerImpl.findMaxPayload failed",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
