package com.qiho.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.api.remoteservice.RemoteConfigService;
import com.qiho.center.biz.service.ConfigService;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author chensong
 * @create 2017-07-17 17:07
 **/
@RestController
public class RemoteConfigServiceImpl implements RemoteConfigService{

    private Logger logger = LoggerFactory.getLogger(RemoteConfigServiceImpl.class);

    @Autowired
    private ConfigService configService;


    @Override
    public DubboResult<String> findByName(String name) {
        return DubboResult.successResult(configService.findByName(name));
    }

    @Override
    public DubboResult<Integer> saveConfig(ConfigParams param) {
        try{
            return DubboResult.successResult(configService.saveConfig(param));
        }catch (Exception e){
            logger.info("Config保存失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateByName(ConfigParams param) {
        return DubboResult.successResult(configService.updateByName(param));
    }

    @Override
    public DubboResult<String> findValueByPayType(PayTypeEnum type) {
        String name = type.getCode();
        return DubboResult.successResult(configService.findByName(name));
    }

    @Override
    public ResultDto<Boolean> insertOrUpdateConfig(ConfigParams params) {
        return configService.insertOrUpdateConfig(params);
    }

    @Override
    public ConfigDto fetchConfigByName(String name) {
        return configService.fetchConfigByName(name);
    }


}


