/**
 * Project Name:qiho-center-biz File Name:RemoteItemPropertyServiceImpl.java Package
 * Name:com.qiho.center.biz.remoteservice.impl Date:2017年5月22日下午10:12:34 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.SkuPropertyValueDto;
import com.qiho.center.api.remoteservice.RemoteItemPropertyService;
import com.qiho.center.biz.service.SkuPropertyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * ClassName:RemoteItemPropertyServiceImpl <br/>
 * Date: 2017年5月22日 下午10:12:34 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@RestController
public class RemoteItemPropertyServiceImpl implements RemoteItemPropertyService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteItemPropertyServiceImpl.class);
    @Autowired
    private SkuPropertyService  skuPropertyService;

    @Override
    public DubboResult<Map<Long, String>> createPropertyNames(List<String> propertyNames) {
        try {
            Map<Long, String> map = skuPropertyService.createPropertyNames(propertyNames);
            return DubboResult.successResult(map);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemPropertyService.createPropertyNames failed, propertyNames={}", propertyNames, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Map<Long, String>> createPropertyValues(List<SkuPropertyValueDto> propertyValues) {
        try {
            Map<Long, String> map = skuPropertyService.createPropertyValues(propertyValues);
            return DubboResult.successResult(map);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemPropertyService.createPropertyValues failed, propertyValues={}", propertyValues, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemPropertyService#updatePropertyValue(java.lang.Long, java.lang.String)
     */
    @Override
    public DubboResult<Void> updatePropertyValue(Long id, String propertyValue) {
        try {
            skuPropertyService.updatePropertyValue(id, propertyValue);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemPropertyService.updatePropertyValue failed,id={}, propertyValue={}", id, propertyValue, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.RemoteItemPropertyService#updatePropertyName(java.lang.Long, java.lang.String)
     */
    @Override
    public void updatePropertyName(Long id, String propertyName) {
        try {
            skuPropertyService.updatePropertyName(id, propertyName);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemPropertyService.updatePropertyName failed,id={}, propertyName={}", id, propertyName, e);
        }
    }

}
