package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.api.remoteservice.RemotePayService;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.common.util.AppLogUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * Created by danke on 2017/7/24.
 */
@RestController
public class RemotePayServiceImpl implements RemotePayService {


    Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private PayChannelDecider payChannelDecider;

    @Override
    public DubboResult<String> submitPay(String orderId, String payType) {
        if (StringUtils.isBlank(orderId) || StringUtils.isBlank(payType))
            return DubboResult.failResult("参数非法,订单id或者支付类型不能为空");
        PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(payType));
        try{
            return DubboResult.successResult(payChannelProcessor.payExecute(orderId,null));
        }catch (Exception e){
            AppLogUtil.error(logger,"提交支付请求失败 msg={} orderId={} payTpye={}",e.getMessage(),orderId, payType);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> notifyCheck(AsyncAcceptParams params) {
        if (StringUtils.isBlank(params.getPayType()))
            return DubboResult.failResult("参数非法,支付类型不能为空");
        PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(params.getPayType()));
        try{
            payChannelProcessor.processNotify(params);
            return DubboResult.successResult(true);
        }catch (Exception e){
            AppLogUtil.error(logger,"提交支付请求失败 reportContent={}",params,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> checkSign(String  map,String payType) {
        PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(payType));
        try{
            Map<String,String> maps =  JSON.parseObject(map, new TypeReference<Map<String, String>>() {
            });
            return DubboResult.successResult(payChannelProcessor.verify(maps));
        }catch (Exception e){
            //catch 延签失败
            return DubboResult.successResult(Boolean.FALSE);
        }
    }

    @Override
    public DubboResult<String> submitPayWithParams(String orderId, String payType,
            Map<String, String> params) {
        if (StringUtils.isBlank(orderId) || StringUtils.isBlank(payType))
            return DubboResult.failResult("参数非法,订单id或者支付类型不能为空");
        PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(payType));
        try{
            return DubboResult.successResult(payChannelProcessor.payExecute(orderId,params));
        }catch (Exception e){
            AppLogUtil.error(logger,"提交支付请求失败 msg={} orderId={} payTpye={}",e.getMessage(),orderId, payType);
            return DubboResult.failResult(e.getMessage());
        }
    }


    @Override
    public DubboResult<String> getOpenIdByCode(String code) {
        PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.WECHATPAY_PUB);
        try{
           return DubboResult.successResult(payChannelProcessor.getOpenIdByCode(code));
        }catch(Exception e){
            AppLogUtil.error(logger,"获取openId失败 msg={},code={}",e.getMessage(),code);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
