package com.qiho.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.biz.service.SkinService;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Date:     2017/7/5 10:30 <br/>
 *
 * @author huika
 * @see
 */
@RestController
public class RemoteSkinServiceImpl implements RemoteSkinService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteItemServiceImpl.class);

    @Autowired
    private SkinService skinService;

    @Override
    public DubboResult<Long> createSkin(SkinDto skinDto) {
        try {
            return DubboResult.successResult(skinService.createSkin(skinDto));
        } catch (Exception e) {
            LOG.error("invoke RemoteSkinServiceImpl.createSkin failed, skinDto={}", skinDto, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateSkin(SkinDto skinDto) {
        try {
            return DubboResult.successResult(skinService.updateSkin(skinDto) > 0);
        } catch (Exception e) {
            LOG.error("invoke RemoteSkinServiceImpl.updateSkin failed, skinDto={}", skinDto, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteSkin(Long id, Long gmtModifier) {
        try {
            return DubboResult.successResult(skinService.deleteSkin(id, gmtModifier) > 0);
        } catch (Exception e) {
            LOG.error("invoke RemoteSkinServiceImpl.deleteSkin failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<SkinDto> querySkinById(Long id) {
        try {
            return DubboResult.successResult(skinService.querySkinById(id));
        } catch (Exception e) {
            LOG.error("invoke RemoteSkinServiceImpl.querySkinById failed, id={}", id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PagenationDto<SkinDto>> queryAllSkin(QuerySkinParams params) {
        try {
            return DubboResult.successResult(skinService.queryAllSkin(params));
        } catch (Exception e) {
            LOG.error("invoke RemoteSkinServiceImpl.queryAllSkin failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
