package com.qiho.center.biz.remoteservice.impl.abtest;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.dto.abtest.TestPlanStrategyDetailDto;
import com.qiho.center.api.params.TestPlanQueryParam;
import com.qiho.center.api.remoteservice.abtest.RemoteTestPlanService;
import com.qiho.center.biz.service.abtest.TestPlanService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/10/10.
 */
@RestController
public class RemoteTestPlanServiceImpl implements RemoteTestPlanService {

	@Resource
	TestPlanService  testPlanService;

	@Override
	public PagenationDto<TestPlanDto> queryTestPlanListByPage(TestPlanQueryParam param) {
		return testPlanService.queryTestPlanListByPage(param);
	}

	@Override
	public boolean updatePlanStatus(Long id, String planStatus,String updator) throws BizException {
		return testPlanService.updatePlanStatus(id,planStatus,updator);
	}

	@Override
	public boolean deleteTestPlan(Long id,String updator) {
		return testPlanService.deleteTestPlan(id,updator);
	}

	@Override
	public boolean publishTestPlan(Long id) throws BizException {
		return testPlanService.publishTestPlan(id);
	}

	@Override
	public int saveTestPlan(TestPlanDto planDto) throws BizException {
		return testPlanService.saveTestPlan(planDto);
	}

	@Override
	public TestPlanDto queryTestPlanById(Long planId) {
		return testPlanService.queryTestPlanById(planId);
	}

	@Override
	public TestPlanStrategyDetailDto queryTestStrategyByItemIdAndUser(Long itemId, String acUserId) {
		return testPlanService.queryTestStrategyByItemIdAndUser(itemId,acUserId);
	}

	@Override
	public TestPlanStrategyDetailDto queryStrategyDetailByPlanCode(String planCode) {
		return testPlanService.queryStrategyDetailByPlanCode(planCode);
	}
}
