package com.qiho.center.biz.remoteservice.impl.advert;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.CollectionAdvertDto;
import com.qiho.center.api.remoteservice.advert.RemoteCollectionAdvertService;
import com.qiho.center.biz.service.advert.CollectionAdvertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-09-12
 */
@RestController
public class RemoteCollectionAdvertServiceImpl implements RemoteCollectionAdvertService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCollectionAdvertServiceImpl.class);

    @Autowired
    private CollectionAdvertService collectionAdvertService;


    @Override
    public ResultDto<Boolean> insertCollectionAdvert(CollectionAdvertDto collectionAdvert) {

        try{
            return collectionAdvertService.insertCollectionAdvert(collectionAdvert);
        } catch (Exception e){
            LOGGER.error("invoke RemoteCollectionAdvertServiceImpl.insertCollectionAdvert error, param={}", collectionAdvert, e);
            return ResultDto.failResult(e.getMessage());
        }
    }

    @Override
    public CollectionAdvertDto findByCollectionId(Long collectionId) {
        return collectionAdvertService.findByCollectionId(collectionId);
    }

    @Override
    public CollectionAdvertDto findById(Long id) {
        return collectionAdvertService.findById(id);
    }

    @Override
    public ResultDto<Boolean> deletedCollectionAdvert(CollectionAdvertDto collectionAdvert) {

        try{
            return collectionAdvertService.deletedCollectionAdvert(collectionAdvert);
        } catch (Exception e){
            LOGGER.error("invoke RemoteCollectionAdvertServiceImpl.deletedCollectionAdvert, param={}", collectionAdvert, e);
            return ResultDto.failResult(e.getMessage());
        }
    }

    @Override
    public ResultDto<Boolean> updateCollectionAdvert(CollectionAdvertDto collectionAdvert) {

        try{
            return collectionAdvertService.updateCollectionAdvert(collectionAdvert);
        } catch (Exception e){
            LOGGER.error("invoke RemoteCollectionAdvertServiceImpl.updateCollectionAdvert error, param={}", collectionAdvert, e);
            return ResultDto.failResult(e.getMessage());
        }
    }

    @Override
    public List<CollectionAdvertDto> listAllCollectionAdvert() {
        return collectionAdvertService.listAllCollectionAdvert();
    }
}
