package com.qiho.center.biz.remoteservice.impl.agent;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentSaveDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentMerchantRelationEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by sunchangji on 2017/12/15.
 */
@RestController
public class RemoteBaiqiAgentBackendServiceImpl implements RemoteBaiqiAgentBackendService {

    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Resource
    private BaiqiAccountService baiqiAccountService;
    @Resource
    private BaiqiAgentMerchantService baiqiAgentMerchantService;
    @Resource
    private MerchantService merchantService;

    @Override
    public List<SimpleIdAndNameDto> findAgentSimple() {
        return baiqiAgentService.findSimpleAll();
    }

    @Override
    public List<SimpleIdAndNameDto> findAgentIdAndName() {

        List<BaiqiAgentEntity> agentEntities = baiqiAgentService.findAll();
        if (CollectionUtils.isEmpty(agentEntities)) {
            return Collections.emptyList();
        }
        List<Long> relationIds = baiqiAccountService.findRelationIdsByAccountType(BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode());
        List<SimpleIdAndNameDto> idAndNameDtos = new ArrayList<>();
        for (BaiqiAgentEntity entity : agentEntities) {
            Long id = entity.getId();
            if (!relationIds.contains(id)) {
                SimpleIdAndNameDto dto = new SimpleIdAndNameDto();
                dto.setId(id);
                dto.setName(entity.getAgentName());
                idAndNameDtos.add(dto);
            }
        }

        return idAndNameDtos;
    }

    @Override
    public PagenationDto<BaiqiAgentDto> find4Page(AgentPageParam params) {
        return baiqiAgentService.find4Page(params);
    }

    @Override
    public Boolean save(BaiqiAgentSaveDto agentSaveDto) throws BizException {
        BaiqiAgentDto agentDto = baiqiAgentService.findByAgentName(agentSaveDto.getAgentName());
        if (agentSaveDto.getId() == null){
            if (agentDto != null) {
                throw new BizException("代理商名称已存在，请勿重复添加");
            }
            //添加代理商
            insert(agentSaveDto);
        }else {
            if (agentDto != null && agentDto.getId().longValue() != agentSaveDto.getId().longValue()) {
                throw new BizException("代理商名称已存在，请勿重复保存");
            }
            //编辑代理商
            update(agentSaveDto);
        }
        return true;
    }

    /**
     * 添加代理商
     * @param agentSaveDto 数据
     */
    private void insert(BaiqiAgentSaveDto agentSaveDto){
        BaiqiAgentEntity entity = BeanUtils.copy(agentSaveDto,BaiqiAgentEntity.class);
        baiqiAgentService.insert(entity);
        List<Long> merchantIds = agentSaveDto.getMerchantIds();
        //插入代理商和商家关联表
        insertAgentMerchant(merchantIds,entity.getId());
    }

    /**
     * 更新代理商信息
     * @param agentSaveDto 数据
     */
    private void update(BaiqiAgentSaveDto agentSaveDto) {
        baiqiAgentService.update(agentSaveDto);
        List<Long> merchantIds = agentSaveDto.getMerchantIds();
        //插入代理商和商家关联表
        insertAgentMerchant(merchantIds,agentSaveDto.getId());
    }

    /**
     * 移除已经存在库中的商家id集合
     * @param merchantIds       商家id集合
     * @param existMerchantIds  需要移除的商家id集合
     * @return 最终插入的商家id集合
     */
    private List<Long> removeAll(List<Long> merchantIds, List<Long> existMerchantIds){
        List<Long> list = new ArrayList<>();
        for (Long merchantId : merchantIds) {
            if (!existMerchantIds.contains(merchantId)) {
                list.add(merchantId);
            }
        }
        return list;
    }

    /**
     * 插入代理商和商家关联表
     * @param merchantIds 商家id集合
     * @param agentId 代理商id
     */
    private void insertAgentMerchant(List<Long> merchantIds, Long agentId){
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            List<Long> existMerchantIds = baiqiAgentMerchantService.findAllMerchantIds();
            List<Long> insertMerchantIds ;
            if (CollectionUtils.isNotEmpty(existMerchantIds)){
                //移除已经存在库中的商家id集合
                insertMerchantIds = removeAll(merchantIds, existMerchantIds);
            }else {
                insertMerchantIds = merchantIds;
            }
            //插入代理商和商家关联表
            if (CollectionUtils.isNotEmpty(insertMerchantIds)) {
                List<BaiqiAgentMerchantRelationEntity> list = new ArrayList<>();
                for (Long id : insertMerchantIds) {
                    BaiqiAgentMerchantRelationEntity entity = new BaiqiAgentMerchantRelationEntity();
                    entity.setAgentId(agentId);
                    entity.setMerchantId(id);
                    list.add(entity);
                }
                baiqiAgentMerchantService.batchInsert(list);
            }
        }

    }

    @Override
    public List<MerchantSimpleDto> findAllIdAndNames() {
        List<Long> merchantIds = baiqiAgentMerchantService.findAllMerchantIds();
        List<MerchantSimpleDto> merchantSimpleDtos = merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        List<MerchantSimpleDto> list = new ArrayList<>();
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            if (!merchantIds.contains(simpleDto.getId())) {
                list.add(simpleDto);
            }
        }
        return list;
    }

    @Override
    public List<MerchantSimpleDto> findMerchantsByAgentId(Long agentId) {
        List<Long> merchantIds = baiqiAgentMerchantService.findExistMerchantIds(agentId);
        if (CollectionUtils.isEmpty(merchantIds)){
            return Collections.emptyList();
        }
        return merchantService.findIdAndNamesByIds(merchantIds);
    }

    @Override
    public List<BaiqiAgentDto> findAll() {
        return BeanUtils.copyList(baiqiAgentService.findAll(),BaiqiAgentDto.class);
    }

    @Override
    public BaiqiAgentDto findAgentByMerchantId(String merchantId) {
        BaiqiAgentEntity agentEntity = baiqiAgentService.findAgentByMerchantId(merchantId);
        return BeanUtils.copy(agentEntity, BaiqiAgentDto.class);
    }
}
