package com.qiho.center.biz.remoteservice.impl.bizlog;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bizlog.QihoBizlogDto;
import com.qiho.center.api.params.bizlog.QihoBizlogParams;
import com.qiho.center.api.remoteservice.bizlog.RemoteBizlogBackendService;
import com.qiho.center.biz.service.bizlog.QihoBizLogService;
import com.qiho.center.common.entityd.qiho.bizlog.QihoBizLogEntity;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by sunchangji on 2017/11/23.
 */
@RestController
public class RemoteBizlogBackendServiceimpl implements RemoteBizlogBackendService {
    @Resource
    private QihoBizLogService qihoBizLogService;

    @Override
    public Long insertBizLog(QihoBizlogDto bizlogDto) {
        return qihoBizLogService.insertBizLog(BeanUtils.copy(bizlogDto, QihoBizLogEntity.class));
    }

    @Override
    public Boolean updateStatusById(Long id, Integer bizStatus) {
        return qihoBizLogService.updateStatusById(id, bizStatus);
    }

    @Override
    public PagenationDto<QihoBizlogDto> findPage(QihoBizlogParams bizlogParams) {
        return qihoBizLogService.findPage(bizlogParams);
    }
}
