package com.qiho.center.biz.remoteservice.impl.component;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;
import com.qiho.center.api.remoteservice.component.RemoteComponentService;
import com.qiho.center.biz.service.component.ComponentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author chensong
 * @create 2018-07-25
 */
@RestController
public class RemoteComponentServiceImpl implements RemoteComponentService {

    @Autowired
    private ComponentService componentService;

    @Override
    public ComponentDto findById(Long id) {
        return componentService.findById(id);
    }

    @Override
    public ResultDto<Long> createComponent(ComponentDto componentDto) {
        return componentService.createComponent(componentDto);
    }

    @Override
    public ResultDto<Long> updateComponent(ComponentDto componentDto) {
        return componentService.updateComponent(componentDto);
    }

    @Override
    public List<ComponentDto> listByType(ComponentTypeEnum type) {
        return componentService.listByType(type);
    }

    @Override
    public List<ComponentDto> listBatchByIds(List<Long> idList) {
        return componentService.listBatchByIds(idList);
    }


}
