package com.qiho.center.biz.remoteservice.impl.finance;

import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;
import com.qiho.center.api.remoteservice.finance.RemoteBaiqiFinanceRechargeBackendService;
import com.qiho.center.biz.service.finance.BaiqiFinanceRechargeService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 账户充值服务
 * Author: zhanghuifeng
 * Date:   9:58 2017/12/21
 */
@RestController
public class RemoteBaiqiFinanceRechargeBackendServiceImpl implements RemoteBaiqiFinanceRechargeBackendService {

	@Resource
	private BaiqiFinanceRechargeService baiqiFinanceRechargeService;

	@Override
	public PagenationDto<BaiqiFinanceRechargeDetailDto> find4Page(BaiqiFinanceRechargeQryParam params) {
		return baiqiFinanceRechargeService.find4Page(params);
	}

	@Override
	public Boolean rechargeSubmit( BaiqiFinanceRechargeDto dto) {
		return baiqiFinanceRechargeService.insert(dto);
	}

	@Override
	public BaseResultDto audit(Long rechargeNo, Integer state, String operator) {
		return baiqiFinanceRechargeService.updateState(state, rechargeNo, operator);
	}

	@Override
	public BaiqiFinanceRechargeDetailDto findByNo(Long rechargeNo) {
		return baiqiFinanceRechargeService.findByNo(rechargeNo);
	}
}
