package com.qiho.center.biz.remoteservice.impl.item;

import java.util.List;
import java.util.concurrent.ExecutorService;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RestController;

import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.center.api.params.item.BatchImportItemEvaluateParams;
import com.qiho.center.api.remoteservice.item.RemoteItemEvaluateBackendService;
import com.qiho.center.biz.runnable.ImportItemEvaluateRunnable;
import com.qiho.center.biz.service.item.ItemEvaluateService;

/**
 * @author jiafeng.geng
 * @date 2018-8-21.
 */
@RestController
public class RemoteItemEvaluateBackendServiceImpl implements RemoteItemEvaluateBackendService, ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemEvaluateBackendServiceImpl.class);

    @Resource
    private ItemEvaluateService itemEvaluateService;

    @Resource
    private ExecutorService executorService;

    private ApplicationContext applicationContext;

    @Override
    public List<ItemEvaluateDto> queryItmeEvalList(Long itemId) {
        List<ItemEvaluateDto> itemEvaluateDtoList = null;
        try {
            itemEvaluateDtoList = itemEvaluateService.queryItmeEvalList(itemId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteItemEvaluateBackendService.queryItmeEvalList failed, itemId={}", itemId, e);
        }
        return itemEvaluateDtoList;
    }

    @Override
    public Integer queryItemEvalCount(Long itemId) {
        Integer result = null;
        try {
            result = itemEvaluateService.queryItemEvalCount(itemId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteItemEvaluateBackendService.queryItemEvalCount failed, itemId={}", itemId, e);
        }
        return result;
    }

    @Override
    public Integer queryMaxSort(Long itemId) {
        Integer result = null;
        try {
            result = itemEvaluateService.queryMaxSort(itemId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteItemEvaluateBackendService.queryMaxSort failed, itemId={}", itemId, e);
        }
        return result;
    }

    @Override
    public Integer addItemEval(ItemEvaluateDto itemEvaluateDto) {
        Integer result = null;
        try {
            result = itemEvaluateService.addItemEval(itemEvaluateDto);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteItemEvaluateBackendService.addItemEval failed, itemEvaluateDto={}",
                itemEvaluateDto, e);
        }
        return result;
    }

    @Override
    public Integer updateItemEval(ItemEvaluateDto itemEvaluateDto) {
        Integer result = null;
        try {
            result = itemEvaluateService.updateItemEval(itemEvaluateDto);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteItemEvaluateBackendService.updateItemEval failed, itemEvaluateDto={}",
                itemEvaluateDto, e);
        }
        return result;
    }

    @Override
    public Integer deletedItemEval(Long itemEvalId) {
        Integer result = null;
        try {
            result = itemEvaluateService.deletedItemEval(itemEvalId);
        } catch (Exception e) {
            LOGGER
                .error("invoke RemoteItemEvaluateBackendService.deletedItemEval failed, itemEvalId={}", itemEvalId, e);
        }
        return result;
    }

    @Override
    public Integer sortItemEval(Long itemId, List<Long> itemEvalIds) {
        Integer result = null;
        try {
            result = itemEvaluateService.sortItemEval(itemId, itemEvalIds);
        } catch (Exception e) {
            LOGGER
                .error("invoke RemoteItemEvaluateBackendService.sortItemEval failed, itemId={}, itemEvalIds={}", itemId,
                    itemEvalIds, e);
        }
        return result;
    }

    @Override
    public Integer batchImportItemEval(String progressKey, List<BatchImportItemEvaluateParams> paramList) {
        Integer result = null;
        try {
            ImportItemEvaluateRunnable runnable = applicationContext.getBean(ImportItemEvaluateRunnable.class);
            runnable.setProgressKey(progressKey);
            runnable.setParamsList(paramList);
            result = runnable.init();
            executorService.submit(runnable);
        } catch (Exception e) {
            LOGGER.error(
                "invoke RemoteItemEvaluateBackendService.batchImportItemEval failed, progressKey={}, paramList={}",
                progressKey, paramList, e);
        }
        return result;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}
