package com.qiho.center.biz.remoteservice.impl.logistics;

import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

import javax.annotation.Resource;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.qiho.center.api.enums.logistics.LogisticsAndExpress100LogisticsEnum;
import com.qiho.center.api.enums.logistics.LogisticsAndExpressBirdEnum;
import com.qiho.center.api.enums.logistics.LogisticsExpressPlatformEnum;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiExpressCodeMappingMapper;
import com.qiho.center.common.daoh.qiho.logistics.Express100LogisticsMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressCodeMappingEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.Express100LogisticsEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RestController;

import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.dto.logistics.LogisticsStatusDto;
import com.qiho.center.api.params.logitics.ExpressBirdReturnParam;
import com.qiho.center.api.remoteservice.logistics.RemoteExpressBackendService;
import com.qiho.center.biz.bo.ExpressBirdBo;
import com.qiho.center.biz.event.FixCheckEvent;
import com.qiho.center.biz.runnable.FixAllRunnable;
import com.qiho.center.biz.runnable.FixSignRunnable;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.util.ExpressBirdProvideUtil;
import com.qiho.center.common.util.ExpressBirdUtil;


/**
 * @author: wangjin
 * @create 2018-06-11 11:13
 **/
@RestController
@BizEventListener
public class RemoteExpressBackendServiceImpl implements RemoteExpressBackendService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExpressBackendServiceImpl.class);

    @Resource
    private ExecutorService executorService;

    @Resource
    private ExpressBirdBo expressBirdBo;

    @Autowired
    private BizEventBus bizEventBus;

    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    @Autowired
    private ApplicationContext context;

    @Resource
    private LogisticsService logisticsService;
    @Resource
    private Express100LogisticsMapper express100LogisticsMapper;
    @Resource
    private BaiqiExpressCodeMappingMapper baiqiExpressCodeMappingMapper;

    LinkedBlockingQueue<LogisticsOrderEntity> blockingQueue = new LinkedBlockingQueue<>();

    private static final int THREED_NUM = 10;

    @Override
    public boolean checkExpressSign(String sign,String data) {
        String createSign;
        try {
            createSign = ExpressBirdProvideUtil.encrypt(data,ExpressBirdUtil.getKey(),"UTF-8");
        }catch (Exception e){
            return false;
        }
        return StringUtils.equals(sign,createSign);
    }

    @Override
    public ExpressBirdReturnParam dealExpressStatus(List<LogisticsStatusDto> list) {

        ExpressBirdReturnParam param = new ExpressBirdReturnParam();
        param.setId(ExpressBirdUtil.getId());
        param.setUpdateTime(new Date());
        param.setReason("");
        for (LogisticsStatusDto item : list){
            if (!expressBirdBo.dealExpressBirdStatus(item.getCode(), item.getPostId(), item.getStatus())){
                param.setSuccess(false);
                return param;
            }
        }
        param.setSuccess(true);
        return param;
    }

    @Override
    public boolean fixExpressSign(Map param) {
//        FixCheckEvent event = new FixCheckEvent();
//        event.setMap(param);
//        bizEventBus.post(event);
        return true;
    }

    @Override
    public void FixAllExpress(Map param) {

        //更新状态
//        qihoLogisticsOrderDAO.updateFixStatus(param);

        FixAllRunnable fixAllRunnable = context.getBean(FixAllRunnable.class,param);
        executorService.submit(fixAllRunnable);

    }

    @Override
    public void backStatus(Map param) {
//        qihoLogisticsOrderDAO.updateOldStatus(param);
    }

    @Override
    public Boolean repairExpress100() {
        List<BaiqiLogisticsEntity> list = logisticsService.findAllByCache();
        Map<String, Long> map = new HashMap<>();
        for (BaiqiLogisticsEntity entity : list) {
            map.put(entity.getLogisticsCode(), entity.getId());
        }
        List<Express100LogisticsEntity> express100LogisticsEntities = new ArrayList<>();
        for (LogisticsAndExpress100LogisticsEnum e : LogisticsAndExpress100LogisticsEnum.values()) {
            Long baiqiLogisticsId = map.get(e.getBaiqiLogisticsCode());
            if (baiqiLogisticsId == null) {
                continue;
            }
            Express100LogisticsEntity entity = new Express100LogisticsEntity();
            entity.setBaiqiLogisticsId(baiqiLogisticsId);
            entity.setLogisticsCode(e.getExpress100Code());
            entity.setLogisticsName(e.getExpress100Name());
            express100LogisticsEntities.add(entity);
        }

        List<String> existCode = express100LogisticsMapper.findExistCodes();
        express100LogisticsEntities.removeIf(express100LogisticsEntity -> existCode.contains(express100LogisticsEntity.getLogisticsCode()));
        if (CollectionUtils.isNotEmpty(express100LogisticsEntities)) {
            express100LogisticsMapper.batchInsert(express100LogisticsEntities);
        }
        return true;
    }

    @Override
    public Boolean repairExpressBird() {
        List<BaiqiLogisticsEntity> list = logisticsService.findAllByCache();
        Map<String, Long> map = new HashMap<>(16);
        for (BaiqiLogisticsEntity entity : list) {
            map.put(entity.getLogisticsCode(), entity.getId());
        }


        List<BaiqiExpressCodeMappingEntity> expressCodeMappingEntities = new ArrayList<>();
        String expressPlatform = LogisticsExpressPlatformEnum.BIRD.getCode();
        for (LogisticsAndExpressBirdEnum e : LogisticsAndExpressBirdEnum.values()) {
            Long baiqiLogisticsId = map.get(e.getBaiqiLogisticsCode());
            if (baiqiLogisticsId == null) {
                continue;
            }
            BaiqiExpressCodeMappingEntity entity = new BaiqiExpressCodeMappingEntity();
            entity.setLogisticsId(baiqiLogisticsId);
            entity.setLogisticsCode(e.getExpressBirdCode());
            entity.setLogisticsName(e.getExpressBirdName());
            entity.setExpressPlatform(expressPlatform);
            expressCodeMappingEntities.add(entity);
        }


        List<String> existCode = baiqiExpressCodeMappingMapper.findExistCodeByCompany(expressPlatform);
        expressCodeMappingEntities.removeIf(expressCodeMappingEntity -> existCode.contains(expressCodeMappingEntity.getLogisticsCode()));
        if (CollectionUtils.isNotEmpty(expressCodeMappingEntities)) {
            baiqiExpressCodeMappingMapper.ExpressCodeBatchInsert(expressCodeMappingEntities);
        }
        return true;
    }

    @Subscribe
    public void AsyFix(FixCheckEvent event){

        Map param = event.getMap();
        try {
            List<LogisticsOrderEntity> list = qihoLogisticsOrderDAO.findByParams(param);
            blockingQueue.addAll(list);
            CountDownLatch countDownLatch = new CountDownLatch(THREED_NUM);
            // 线程处理批量处理
            for (int i = 0;i<THREED_NUM;i++){

                FixSignRunnable fixSignRunnable = context.getBean(FixSignRunnable.class,blockingQueue,countDownLatch);
                executorService.submit(fixSignRunnable);
            }
            countDownLatch.await();
            blockingQueue.clear();
            LOGGER.info("快递签收 修复完成");
        }catch (Exception e){
            LOGGER.error("签收 修复失败",e);
        }
    }
}
