package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.merchant.BaiqiMerchantLinkService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author chensong
 * @create 2017-11-15 10:58
 **/
@RestController
public class RemoteMerchantServiceImpl implements RemoteMerchantService {

    @Autowired
    private MerchantService merchantService;

    @Autowired
    private BaiqiAccountService baiqiAccountService;

    @Autowired
    private BaiqiMerchantLinkService merchantLinkService;

    @Resource
    private MerchantUndeliveryService merchantUndeliveryService;

    @Override
    public MerchantDto findById(Long merchantId) {
        return merchantService.findById(merchantId);
    }

    @Override
    public Boolean saveMerchant(MerchantDto dto) throws BizException {
        return merchantService.saveMerchant(dto);
    }

    @Override
    public PagenationDto<MerchantDto> querypage(MerchantQueryParams params) {
        return merchantService.queryPage(params);
    }

    @Override
    public List<MerchantDto> findListByName(String name) {
        return merchantService.findByName(name);
    }

    @Override
    public MerchantDto findByItemId(Long itemId) {
        return merchantService.findByItemId(itemId);
    }

    @Override
    public List<SimpleIdAndNameDto> findAllMerchantSimple() {
        List<MerchantSimpleDto> merchantSimpleDtos = merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        List<SimpleIdAndNameDto> idAndNameDtos = new ArrayList<>(merchantSimpleDtos.size());
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            SimpleIdAndNameDto idAndNameDto = new SimpleIdAndNameDto();
            idAndNameDto.setId(simpleDto.getId());
            idAndNameDto.setName(simpleDto.getMerchantName());
            idAndNameDtos.add(idAndNameDto);
        }

        return idAndNameDtos;
    }

    @Override
    public List<SimpleIdAndNameDto> findAllIdAndNames() {
        List<Long> merchantIds = baiqiAccountService
            .findRelationIdsByAccountType(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode());
        List<MerchantSimpleDto> merchantSimpleDtos = merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        List<SimpleIdAndNameDto> filterDtos = new ArrayList<>();
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            if (!merchantIds.contains(simpleDto.getId())) {
                SimpleIdAndNameDto simple = new SimpleIdAndNameDto();
                simple.setId(simpleDto.getId());
                simple.setName(simpleDto.getMerchantName());
                filterDtos.add(simple);
            }
        }
        return filterDtos;
    }

    @Override
    public List<MerchantSpacialDto> findAll() {
        return BeanUtils.copyList(merchantService.findAll(), MerchantSpacialDto.class);
    }

    @Override
    public Long findRelationIdByMerchantIdAndRelationType(Long merchantId, BaiqiMerchantLinkTypeEnum relationType) {
        return merchantLinkService.findRelationIdByMerchantIdAndRelationType(merchantId, relationType);
    }

    @Override
    public List<String> findUndelivery(Long merchantId) {
        return merchantUndeliveryService.findUndelivery(merchantId);
    }

    @Override
    public PagenationDto<OpenInterfaceDto> openInterfacePageQuery(OpenInterfaceQueryParams params) {
        return merchantService.openInterfacePageQuery(params);
    }

    @Override
    public Boolean saveOpenInterface(OpenInterfaceDto dto) {
        return merchantService.saveOpenInterface(dto);
    }

    @Override
    public Boolean updateOpenInterface(OpenInterfaceDto dto) {
        return merchantService.updateOpenInterface(dto);
    }

    @Override
    public OpenInterfaceDto findByMerchantId(Long merchantId) {
        return merchantService.findByMerchantId(merchantId);
    }

    @Override
    public OpenInterfaceDto findByAppKey(String appKey) {
        return merchantService.findByAppKey(appKey);
    }

    @Override
    public List<MerchantSimpleDto> findNoOpenInterface(String merchantName) {
        return merchantService.findNoOpenInterface(merchantName);
    }

    @Override
    public Boolean initOpenInterface(OpenInterfaceDto dto) {
        return merchantService.updateOpenInterface(dto);
    }

    @Override
    public Integer findHasAppKeyCount() {
        return merchantService.findHasAppKeyCount();
    }

    @Override
    public OpenInterfaceDto checkedAppKey(String appKey, String appSecret) {
        return merchantService.checkedAppKey(appKey, appSecret);
    }

    @Override
    public boolean updateVersionSign(String versionSign,Long id) {
        return merchantService.updateVersionSign(versionSign, id);
    }
}
