package com.qiho.center.biz.remoteservice.impl.message;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;
import com.qiho.center.api.remoteservice.message.RemoteMessageBackendService;
import com.qiho.center.biz.service.message.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author: wangjin
 * @create 2018-07-02 15:15
 **/
@RestController
public class RemoteMessageBackendServiceImpl implements RemoteMessageBackendService {

    @Autowired
    private MessageService messageService;


    @Override
    public boolean saveMessage(MessageNotifyDto dto) {
        if (messageService.saveMessage(dto)>0){
            return true;
        }else {
            return false;
        }
    }

    @Override
    public boolean saveAndPublishMessage(MessageNotifyDto dto) {
        return messageService.saveAndPublishMessage(dto);
    }

    @Override
    public PagenationDto<MessageNotifyDto> findMessages(MessageNotifyPagingParams params) {
        return messageService.findMessages(params);
    }

    @Override
    public MessageNotifyDto findMessageById(Long id) {
        return messageService.findMessageById(id);
    }

    @Override
    public boolean deleteMessage(Long id) {
        return messageService.deleteMessage(id);
    }
}
