package com.qiho.center.biz.remoteservice.impl.orderexport;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.center.api.remoteservice.orderexport.RemoteOrderExportTemplateBackendService;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateFieldService;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateService;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 订单导出模板service实现
 *
 * @author peanut.huang
 * @date 2017/11/27.
 */
@RestController
public class RemoteOrderExportTemplateBackendServiceImpl implements RemoteOrderExportTemplateBackendService {

    @Resource
    private OrderExportTemplateService orderExportTemplateService;
    @Resource
    private OrderExportTemplateFieldService orderExportTemplateFieldService;


    @Override
    public PagenationDto<OrderExportTemplateDto> find4Page(OrderExportTemplateQueryParams templateQueryParams) {
        return orderExportTemplateService.find4Page(templateQueryParams);
    }

    @Override
    public List<OrderExportTemplateDto> findTemp4Select() {
        return orderExportTemplateService.findTemp4Select();
    }

    @Override
    public Boolean save(Long id, String tempName) {
        return orderExportTemplateService.save(id, tempName);
    }

    @Override
    public Boolean deleteById(Long id) {
        return orderExportTemplateService.deleteById(id);
    }

    @Override
    public TemplateFieldDto findTempField(Long tempFieldId) {
        return orderExportTemplateFieldService.findById(tempFieldId);
    }

    @Override
    public List<TemplateFieldDto> findTempFields(Long tempId) {
        return orderExportTemplateFieldService.findByTempId(tempId);
    }

    @Override
    public Boolean deleteTempField(Long tempFieldId) {
        return orderExportTemplateFieldService.deleteById(tempFieldId);
    }

    @Override
    public Boolean saveTempField(TemplateFieldDto templateFieldDto) {
        return orderExportTemplateFieldService.saveTempField(templateFieldDto);
    }

    @Override
    public List<FieldDto> findField4Select() {
        return orderExportTemplateFieldService.findField4Select();
    }
}
