package com.qiho.center.biz.remoteservice.impl.page;

import com.qiho.center.api.dto.page.CollItemDto;
import com.qiho.center.api.dto.page.CollItemSaveDto;
import com.qiho.center.api.remoteservice.page.RemoteCollItemBackendService;
import com.qiho.center.biz.service.page.CollItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-24.
 */
@RestController
public class RemoteCollItemBackendServiceImpl implements RemoteCollItemBackendService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCollItemBackendServiceImpl.class);

    @Resource
    private CollItemService collItemService;

    @Override
    public List<CollItemDto> queryItemListBySort(Long collId) {
        List<CollItemDto> collItemDtoList = null;
        try {
            collItemDtoList = collItemService.queryItemListBySort(collId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.queryItemListBySort failed, collId={}", collId, e);
        }
        return collItemDtoList;
    }

    @Override
    public List<CollItemDto> queryItemListBySortWithItemIds(Long collId, List<Long> collItemIds) {
        List<CollItemDto> collItemDtoList = null;
        try {
            collItemDtoList = collItemService.queryItemListBySortWithItemIds(collId, collItemIds);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.queryItemListBySortWithItemIds failed, collId={}, collItemIds={}", collId, collItemIds, e);
        }
        return collItemDtoList;
    }

    @Override
    public Integer addCollItemList(List<CollItemSaveDto> collItemSaveDtoList) {
        Integer result = null;
        try {
            result = collItemService.addCollItemList(collItemSaveDtoList);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.addCollItemList failed, collItemSaveDtoList={}", collItemSaveDtoList, e);
        }
        return result;
    }


    @Override
    public Integer updateCollItemList(List<CollItemSaveDto> collItemSaveDtoList) {
        Integer result = null;
        try {
            result = collItemService.updateCollItemList(collItemSaveDtoList);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.updateCollItemList failed, collItemSaveDtoList={}", collItemSaveDtoList, e);
        }
        return result;
    }

    @Override
    public Integer findMaxSort(Long collId) {
        Integer result = null;
        try {
            result = collItemService.findMaxSort(collId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.findMaxSort failed, collId={}", collId, e);
        }
        return result;
    }

    @Override
    public Integer deleted4Phy(Long collId, Long itemId) {
        Integer result = null;
        try {
            result = collItemService.deleted4Phy(collId, itemId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.deleted4Phy failed, collId={}, itemId={}", collId, itemId, e);
        }
        return result;
    }

    @Override
    public Integer batchDeleted(List<Long> itemIds) {
        Integer result = null;
        try {
            result = collItemService.batchDeleted(itemIds);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.batchDeleted failed, itemIds={}", itemIds, e);
        }
        return result;
    }

    @Override
    public Integer sort(Long collId, List<Long> itemIds) {
        Integer result = null;
        try {
            result = collItemService.sort(collId, itemIds);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.sort failed, collId={}, itemIds={}", collId, itemIds, e);
        }
        return result;
    }

    @Override
    public Integer updateStatusBatch(Long collId, List<Long> itemIds, Integer collItemStatus) {
        Integer result = null;
        try {
            result = collItemService.updateStatusBatch(collId, itemIds, collItemStatus);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.updateStatusBatch failed, collId={}, itemIds={}, collItemStatus={}", collId, itemIds, collItemStatus, e);
        }
        return result;
    }

    @Override
    public CollItemDto queryItem(Long collId, Long itemId) {
        CollItemDto collItemDto = null;
        try {
            collItemDto = collItemService.queryItem(collId, itemId);
        } catch (Exception e) {
            LOGGER.error("invoke RemoteCollItemBackendService.queryItem failed, collId={}, itemId={}", collId, itemId, e);
        }
        return collItemDto;
    }
}
