package com.qiho.center.biz.remoteservice.impl.page;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.PageComponentDetailDto;
import com.qiho.center.api.dto.page.PageComponentDto;
import com.qiho.center.api.remoteservice.page.RemotePageComponentService;
import com.qiho.center.biz.service.page.PageComponentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author chensong
 * @create 2018-08-02
 */
@RestController
public class RemotePageComponentServiceImpl implements RemotePageComponentService {


    private static final Logger LOGGER = LoggerFactory.getLogger(RemotePageComponentServiceImpl.class);

    @Autowired
    private PageComponentService pageComponentService;

    @Override
    public ResultDto<Boolean> savePageComponent(BaiqiPageDto pageDto, List<PageComponentDto> pageComponentList) {

        try{

            return pageComponentService.savePageComponent(pageDto, pageComponentList);

        } catch (Exception e){

            LOGGER.error("invoke RemotePageComponentService.savePageComponent error, pageDto={}, pageComponentList={}",
                    pageDto, pageComponentList, e);
            return ResultDto.failResult("保存组件页面出错");
        }
    }

    @Override
    public PageComponentDetailDto findPageComponentById(Long pageId) {
        return pageComponentService.findPageComponentById(pageId);
    }
}
