package com.qiho.center.biz.runnable;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @author: wangjin
 * @create 2018-08-09 10:03
 **/
@Component
@Scope("prototype")
public class FixAllRunnable implements Runnable {

    private static final Logger LOGGER = LoggerFactory.getLogger(FixAllRunnable.class);
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    @Autowired
    private KuaiDi100Bo kuaiDi100Bo;

    private Map map;

    public FixAllRunnable(Map map){
        this.map = map;
    }

    @Override
    public void run() {
        //查询
        List<LogisticsOrderEntity> list = qihoLogisticsOrderDAO.findByParams(map);
        List<LogisticsOrderDo> fixList = BeanUtils.copyList(list,LogisticsOrderDo.class);

        kuaiDi100Bo.dealpostOrders(fixList);
        //订阅
        LOGGER.info("修复订阅完成");
    }
}
