package com.qiho.center.biz.runnable;

import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * 修复快递签收状态
 * @author: wangjin
 * @create 2018-07-24 19:47
 **/
@Component
@Scope("prototype")
public class FixSignRunnable implements Runnable {

    private final CountDownLatch countDownLatch;


    @Autowired
    private ExpressBo expressBo;

    private LinkedBlockingQueue<LogisticsOrderEntity> blockingQueue;

    public FixSignRunnable(LinkedBlockingQueue<LogisticsOrderEntity> blockingQueue, CountDownLatch countDownLatch){
        this.blockingQueue = blockingQueue;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {

        while (true){
            LogisticsOrderEntity entity = blockingQueue.poll();
            if (ObjectUtils.isEmpty(entity)){
                break;
            }
            expressBo.queryStatus(entity.getLogisticsCode(),entity.getPostId(),entity.getOrderId());
        }
        countDownLatch.countDown();
    }
}
