package com.qiho.center.biz.runnable;

import java.util.List;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.qiho.center.api.params.item.BatchImportItemEvaluateParams;
import com.qiho.center.biz.bo.ItemEvaluateBo;

/**
 * @author jiafeng.geng
 * @date 2018-8-31
 */
@Component
@Scope("prototype")
public class ImportItemEvaluateRunnable implements Runnable {

    private Logger LOGGER = LoggerFactory.getLogger(ImportItemEvaluateRunnable.class);

    @Autowired
    private ItemEvaluateBo itemEvaluateBo;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    private List<BatchImportItemEvaluateParams> paramsList = Lists.newArrayList();

    private BoundHashOperations<String, String, Object> ops;

    public Integer init() {
        return paramsList.size();
    }

    @Override
    public void run() {
        try {
            itemEvaluateBo.BatchimportItemEvaluate(paramsList);
        } catch (Exception e) {
            LOGGER.info("导入商品评价异常, paramsList={}", paramsList, e);
        }
    }

    public void setProgressKey(String progressKey) {
        this.ops = redisTemplate.boundHashOps(progressKey);
    }

    public void setParamsList(List<BatchImportItemEvaluateParams> paramsList) {
        this.paramsList.addAll(paramsList);
    }
}
