package com.qiho.center.biz.service;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.params.MediaPlanParams;

/**
 * Created by danke on 2017/6/16.
 * 媒体计划的服务
 */
public interface MediaPlanService {

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    MediaPlanDto findById(Long id);

    /**
     * 通过条件分页查询
     *
     * @param params
     * @return
     */
    PagenationDto<MediaPlanDto> findByQuery(MediaPlanParams params, Integer pageNum, Integer pageSize);

    /**
     * 更新媒体计划
     *
     * @param mediaPlanDto
     * @return
     */
    Integer updateMediaPlan(MediaPlanDto mediaPlanDto);

    /**
     * 通过id删除媒体计划
     *
     * @param id
     * @return
     */
    Integer deleteMediaById(Long id, String gmtModifier);

    /**
     * 新增媒体计划
     *
     * @param mediaPlanDto
     * @return
     */
    Integer insertMediaPlan(MediaPlanDto mediaPlanDto);

    /**
     * 通过条件查询记录数
     */
    Integer countMediaPlanByQuery(MediaPlanParams params);

    /**
     * 通过channelId更新mediaplan
     */
    int updateMediaPlanByChannelId(MediaPlanDto mediaPlanDto);
}
