package com.qiho.center.biz.service;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.PopupWindowDto;

import java.util.List;

/**
 * @author: jiafeng.geng
 * @create 2018-05-30
 */
public interface PopupWindowService {

    /**
     * 增加弹窗
     *
     * @param popupWindowDto
     * @return
     */
    Integer add(PopupWindowDto popupWindowDto);

    /**
     * 删除弹窗
     *
     * @param ids
     * @return
     */
    Integer deleteList(List<Long> ids);

    /**
     * 更新弹窗
     *
     * @param popupWindowDto
     * @return
     */
    Integer update(PopupWindowDto popupWindowDto);

    /**
     * 查询弹窗列表
     *
     * @param
     * @return
     */
    PagenationDto<PopupWindowDto> queryList();

    /**
     * 条件查询弹窗列表
     *
     * @param popupWindowDto
     * @return
     */
    PagenationDto<PopupWindowDto> queryByParam(PopupWindowDto popupWindowDto);

    /**
     * 关闭所有弹窗状态
     *
     * @param
     * @return
     */
    Integer closeOnStatus();

    /**
     * 根据id集合查询弹窗列表
     *
     * @param ids
     * @return
     */
    PagenationDto<PopupWindowDto> queryByIds(List<Long> ids);

}
