package com.qiho.center.biz.service.account;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.common.entityd.qiho.account.BaiqiAccountEntity;

import java.util.List;

/**
 * Created by sunchangji on 2017/12/7.
 */
public interface BaiqiAccountService {

    BaiqiAccountDto findByAccount(String account);

    BaiqiAccountDto findByMobile(String mobile);

    boolean deleteById(Long id);

    PagenationDto<BaiqiMainAndAgenAccountDto> findPageAccount(AccountPageParam pageQueryParams);

    /**
     * 禁用主账号
     *
     * @param id
     * @return
     */
    Boolean disableMainAccount(Long id) throws BizException;

    /**
     * 查询所有子账号
     *
     * @param parentId 主账号id
     * @return
     */
    List<BaiqiAccountDto> findByParentId(Long parentId);

    /**
     * 查询所有启用状态主账号的账号名称
     *
     * @return
     */
    List<String> findAllMainAccount();

    /**
     * 账号生效
     *
     * @param id 账号id
     * @return
     */
    Boolean enable(Long id);

    /**
     * 账号失效
     *
     * @param id 账号id
     * @return
     */
    Boolean disable(Long id);

    /**
     * 保存账号
     *
     * @param accountDto
     * @return
     */
    Boolean save(BaiqiAccountDto accountDto) throws BizException;

    /**
     * 查询账号
     *
     * @param id 账号id
     * @return
     */
    BaiqiAccountDto findById(Long id);

    /**
     * 根据id查询账号名称
     *
     * @param id 账号id
     * @return 账号名称
     */
    String findAccountById(Long id);

    /**
     * 更新
     *
     * @param accountEntity
     * @return
     */
    Boolean update(BaiqiAccountEntity accountEntity);

    /**
     * 根据账户类型查询关联id
     *
     * @param accountType
     * @return
     */
    List<Long> findRelationIdsByAccountType(Integer accountType);

    /**
     * 根据商家id查询商家主账号
     *
     * @param merchantId 商家id
     * @return
     */
    BaiqiAccountEntity findMainAccountByMerchantId(Long merchantId);

    /**
     * 根据账户类型和关联id查询账户
     *
     * @return
     */
    BaiqiAccountEntity findByTypeAndRelationId(Integer accountType, Long relationId);

    /**
     * 查询出已经有主账号的商家ids
     *
     * @param merchantIds
     * @return
     */
    List<Long> filterMerchantIds(List<Long> merchantIds);
}
