package com.qiho.center.biz.service.advert;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.CollectionAdvertDto;

import java.util.List;

/**
 * 集合页广告位服务接口
 *
 * @author chensong
 * @create 2018-09-12
 */
public interface CollectionAdvertService {

    /**
     * 保存集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    ResultDto<Boolean> insertCollectionAdvert(CollectionAdvertDto collectionAdvert);

    /**
     * 根据集合页id查找 集合页广告位关联记录
     * @param collectionId
     * @return
     */
    CollectionAdvertDto findByCollectionId(Long collectionId);

    /**
     * 根据集合页广告位id查找集合页广告位关联记录
     * @param id
     * @return
     */
    CollectionAdvertDto findById(Long id);

    /**
     * 删除集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    ResultDto<Boolean> deletedCollectionAdvert(CollectionAdvertDto collectionAdvert);

    /**
     * 修改集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    ResultDto<Boolean> updateCollectionAdvert(CollectionAdvertDto collectionAdvert);

    /**
     * 查询所有的集合页广告位记录
     * @return
     */
    List<CollectionAdvertDto> listAllCollectionAdvert();






}
