package com.qiho.center.biz.service.advert;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;

import java.util.List;


/** 商品&广告计划相关服务接口
 * @author chensong
 * @create 2018-01-05 11:35
 **/
public interface ItemPlanService {

    /**
     * 分页查询
     * @param params
     * @return
     */
    PagenationDto<ItemAdvertPlanDto> queryPage(ItemPlanQueryParams params);

    /**
     * 获取未绑定的广告计划
     * @param itemId
     * @return
     */
    List<TuiaPlanDto> getUnbindPlan(Long itemId);

    /**
     * 关联广告计划
     * @param params
     * @return
     */
    Boolean bingPlan(ItemBindPlanParams params) throws BizException;





}
