package com.qiho.center.biz.service.component;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;

import java.util.List;

/** 组件服务接口
 * @author chensong
 * @create 2018-07-24
 */
public interface ComponentService {

    /**
     * 根据id获取
     * @param id
     * @return
     */
    ComponentDto findById(Long id);

    /**
     * 新增组件
     * @param component
     * @return
     */
    ResultDto<Long> createComponent(ComponentDto component);

    /**
     * 更细组件
     * @param component
     * @return
     */
    ResultDto<Long> updateComponent(ComponentDto component);

    /**
     * 根据类型获取主键列表
     * @param type
     * @return
     */
    List<ComponentDto> listByType(ComponentTypeEnum type);

    /**
     * 根据id集合批量获取组件
     * @param idList
     * @return
     */
    List<ComponentDto> listBatchByIds(List<Long> idList);




}
