package com.qiho.center.biz.service.finance;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.dto.finance.HistoricalBalanceDto;
import com.qiho.center.api.enums.finance.CashRebateAmountEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;

import java.util.List;

/**
 * 商户资金账户服务接口
 *
 * @author chensong
 * @create 2017-12-19 18:45
 **/
public interface FinanceService {

    /**
     * 创建资金账户
     *
     * @param dto
     * @return
     */
    Boolean insertFinance(FinanceDto dto);

    /**
     * c查询所有财务基础实体类
     *
     * @return
     */
    PagenationDto<FinanceDto> findAll(FinanceBasePageParam pageParam);

    /**
     * 查询商家
     * 账户信息
     *
     * @param merchantId
     * @return
     */
    FinanceDto findFinanceByMerchantId(long merchantId);

    /**
     * 根据关联查询
     *
     * @param typeEnum   关联类型
     * @param relationId 关联id
     * @return
     */
    BaiqiFinanceEntity findByRelation(FinanceTypeEnum typeEnum, Long relationId);

    /**
     * 计算现金和返回金额
     *
     * @param financeId            账户ID
     * @param amount               操作金额
     * @param cashRebateAmountEnum 操作类型
     * @return
     */
    CashRebateAmountBean calcCashAndRebateAmount(Long financeId, Long amount,
        CashRebateAmountEnum cashRebateAmountEnum);

    /**
     * 修改账户金额
     *
     * @param financeId
     * @param cashRebateAmountBo
     * @return
     */
    Boolean updateFinanceAmountById(Long financeId, CashRebateAmountBean cashRebateAmountBo) throws BizException;

    /**
     * 查询财务基础信息的总条数
     *
     * @param
     * @param
     * @return
     */
    Integer findBaseInfoCount();

    /**
     * 根据筛选条件查询财务基础实体类
     *
     * @return
     */
    List<FinanceDto> findByParam(BaiqiMerchantFreetextParam pageParam);

    /**
     * 查询所有财务历史余额实体类
     *
     * @return
     */
    PagenationDto<HistoricalBalanceDto> findAllHistoricalBalance(PageQueryParams pageParam);
}
