package com.qiho.center.biz.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.ChannelDto;
import com.qiho.center.api.params.ChannelParams;
import com.qiho.center.biz.service.ChannelService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoChannelDAO;
import com.qiho.center.common.entity.campaign.QihoChannelEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by danke on 2017/6/16.
 */
@Service
public class ChannelServiceImpl implements ChannelService {

    /**
     * 日志
     */
    Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 渠道dal
     */
    @Resource
    private QihoChannelDAO qihoChannelDAO;

    @Override
    public ChannelDto findById(Long id) {
        QihoChannelEntity entity = qihoChannelDAO.findById(id);
        if (null == entity)
            return null;
        return BeanUtils.copy(entity, ChannelDto.class);
    }

    @Override
    public PagenationDto<ChannelDto> findByQuery(ChannelParams params, Integer pageNum, Integer pageSize) {
        List<ChannelDto> channelDtos = new ArrayList<>();
        PagenationDto<ChannelDto> resultBase = new PagenationDto<>();
        List<QihoChannelEntity> entities = qihoChannelDAO.findByQuery(params, pageNum, pageSize);
        if (CollectionUtils.isEmpty(entities))
            return resultBase;
        //遍历集合,封装参数
        entities.stream().forEach(e -> channelDtos.add(BeanUtils.copy(e, ChannelDto.class)));
        resultBase.setList(channelDtos);
        //查询total
        Integer channelCount = qihoChannelDAO.countByQuery(params);
        resultBase.setTotal(channelCount);
        return resultBase;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer updateChannel(ChannelDto channelDto) {
        return qihoChannelDAO.updateByEntity(channelDto);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer deleteChannelById(Long id, String updator) {
        return qihoChannelDAO.deleteById(id, updator);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer insertChannel(ChannelDto channelDto) {
        Long result = qihoChannelDAO.insert(channelDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    @Override
    public Integer countChannelByQuery(ChannelParams params) {
        return qihoChannelDAO.countByQuery(params);
    }

}
