package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.PopupWindowDto;
import com.qiho.center.biz.service.PopupWindowService;
import com.qiho.center.common.daoh.qiho.QihoPopupWindowMapper;
import com.qiho.center.common.entityd.qiho.QihoPopupWindowEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 弹窗服务
 *
 * @author: jiafeng.geng
 * @create 2018-05-30
 */
@Service
public class PopupWindowServiceImpl implements PopupWindowService {

    @Resource
    private QihoPopupWindowMapper popupWindowMapper;

    @Override
    public Integer add(PopupWindowDto popupWindowDto) {
        return popupWindowMapper.insert(BeanUtils.copy(popupWindowDto, QihoPopupWindowEntity.class));
    }

    @Override
    public Integer deleteList(List<Long> ids) {
        return popupWindowMapper.deleteByIds(ids);
    }

    @Override
    public Integer update(PopupWindowDto popupWindowDto) {
        return popupWindowMapper.updateById(BeanUtils.copy(popupWindowDto, QihoPopupWindowEntity.class));
    }

    @Override
    public PagenationDto<PopupWindowDto> queryList() {
        // 查询所有弹窗对象集合
        List<QihoPopupWindowEntity> popupWindowEntityList = popupWindowMapper.queryList();

        // 封装对象
        PagenationDto<PopupWindowDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setList(CollectionUtils.isEmpty(popupWindowEntityList) ? null : entityToDto(popupWindowEntityList));
        return pagenationDto;
    }

    @Override
    public PagenationDto<PopupWindowDto> queryByParam(PopupWindowDto popupWindowDto) {
        // 参数类型转换
        QihoPopupWindowEntity popupWindowEntity = BeanUtils.copy(popupWindowDto, QihoPopupWindowEntity.class);

        // 根据参数查询弹窗对象集合、数量
        List<QihoPopupWindowEntity> popupWindowEntityList = popupWindowMapper.selectByParam(popupWindowEntity);

        // 封装对象
        PagenationDto<PopupWindowDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setTotal(popupWindowEntityList.size());
        pagenationDto.setList(entityToDto(popupWindowEntityList));
        return pagenationDto;
    }

    private List<PopupWindowDto> entityToDto(List<QihoPopupWindowEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List<PopupWindowDto> result = Lists.newArrayList();
        list.forEach(popupWindowEntity -> result.add(BeanUtils.copy(popupWindowEntity, PopupWindowDto.class)));
        return result;
    }

    @Override
    public Integer closeOnStatus() {
        // 查询所有状态为开启的弹窗列表
        QihoPopupWindowEntity popupWindowEntityParam = new QihoPopupWindowEntity();
        popupWindowEntityParam.setPopupWindowStatus(true);
        List<QihoPopupWindowEntity> popupWindowEntityList = popupWindowMapper.selectByParam(popupWindowEntityParam);

        // 获取所有状态为开启的弹窗id集合
        List<Long> ids = popupWindowEntityList.stream().map(QihoPopupWindowEntity::getId).collect(Collectors.toList());

        // 根据弹窗id关闭所有弹窗
        return popupWindowMapper.closeOnStatus(ids);
    }

    @Override
    public PagenationDto<PopupWindowDto> queryByIds(List<Long> ids) {
        // 根据弹窗id集合查询弹窗对象集合
        List<QihoPopupWindowEntity> popupWindowEntityList = popupWindowMapper.queryByIds(ids);

        // 封装对象
        PagenationDto<PopupWindowDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setList(CollectionUtils.isEmpty(popupWindowEntityList) ? null : entityToDto(popupWindowEntityList));
        return pagenationDto;
    }
}
