package com.qiho.center.biz.service.impl.abtest;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestPlanDetailDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.dto.abtest.TestPlanStrategyDetailDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.enums.PlanStatusEnum;
import com.qiho.center.api.params.TestPlanQueryParam;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.abtest.TestPlanService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.QihoMetadataDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entityd.qiho.abtest.QihoMetadataDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanEntity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.dayu.api.client.DayuClient;
import cn.com.duiba.dayu.api.dto.Experiment;
import cn.com.duiba.dayu.api.dto.Layer;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.enums.DiversionTypeEnum;
import cn.com.duiba.dayu.api.remoteservice.RemoteDayuABService;
import cn.com.duiba.dayu.api.result.DayuResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by qianjue on 2017/10/10.
 */
@Service
public class TestPlanServiceImpl implements TestPlanService {

    private Logger logger = LoggerFactory.getLogger(TestPlanServiceImpl.class);

    @Resource
    private ItemService itemService;

    private static String suffix = "_";

    private static String scnceName = "奇货A/Btest-";

    @Resource
    QihoTestPlanMapper qihoTestPlanMapper;

    @Resource
    QihoTestPlanDetailMapper qihoTestPlanDetailMapper;

    @Resource
    QihoTestMetadataMapper qihoTestMetadataMapper;

    @Resource
    QihoMetadataDetailMapper qihoMetadataDetailMapper;

    @Resource
    RemoteDayuABService remoteDayuABService;

    @Resource
    private DayuClient dayuClient;

    @Override
    public PagenationDto<TestPlanDto> queryTestPlanListByPage(TestPlanQueryParam param) {
        PagenationDto<TestPlanDto> result = new PagenationDto<>();
        int count = qihoTestPlanMapper.selectPageCount(param);
        if (count == 0) {
            return result;
        }
        result.setTotal(count);
        List<QihoTestPlanEntity> list = qihoTestPlanMapper.selectByPage(param);
        List<TestPlanDto> resultList = Lists.newArrayList();
        list.stream().forEach(entity -> {
            TestPlanDto testPlanDto = BeanUtils.copy(entity, TestPlanDto.class);
            ItemSimpleDto itemSimpleDto = itemService.queryItemSimpleDto(entity.getItemId());
            testPlanDto.setItemName(null != itemSimpleDto ? itemSimpleDto.getItemName() : "");
            resultList.add(testPlanDto);
        });
        result.setList(resultList);
        return result;
    }

    @Override
    public boolean updatePlanStatus(Long id, String planStatus, String updator) throws BizException {
        //处于未发布状态的测试计划不能被暂停和恢复操作
        QihoTestPlanEntity entity = qihoTestPlanMapper.selectById(id);
        if (StringUtils.equals(entity.getPlanStatus(), PlanStatusEnum.TO_PUBLISH.getCode())) {
            throw new BizException("待发布状态活动不能被暂停和恢复");
        }
        entity.setPlanStatus(planStatus);
        entity.setUpdator(updator);
        return 1 == qihoTestPlanMapper.update(entity);
    }

    @Override
    public boolean deleteTestPlan(Long id, String updator) {
        return 1 == qihoTestPlanMapper.delete(id, updator);
    }

    @Override
    public boolean publishTestPlan(Long id) throws BizException {
        //查询活动的基本信息
        QihoTestPlanEntity planEntity = qihoTestPlanMapper.selectById(id);
        //如果没有场景ID,意味着是新增的场景
        Long senceId = null;
        if (null == planEntity.getSenceId()) {
            senceId = remoteDayuABService.createScene(scnceName + planEntity.getId());
            planEntity.setSenceId(senceId);
        } else {
            senceId = planEntity.getSenceId();
        }
        planEntity.setPlanStatus(PlanStatusEnum.NORMAL.getCode());
        qihoTestPlanMapper.update(planEntity);
        //创建layer信息
        Layer layer = new Layer();
        layer.setDiversion(DiversionTypeEnum.CONSUMER_ID_HASH);
        List<Experiment> experiments = Lists.newArrayList();
        List<String> codeList = Splitter.on(",").trimResults().splitToList(planEntity.getPlanCode());
        codeList.stream().forEach(code -> {
            List<QihoTestPlanDetailEntity> list = qihoTestPlanDetailMapper.selectListByCode(code);
            Experiment experiment = new Experiment();
            experiment.setFlowRate(list.get(0).getFlowPercent().intValue());
            experiment.setName(code);
            experiment.setId(list.get(0).getExperimentId());
            Map<String, String> arguments = Maps.newHashMap();
            arguments.put("planCode", code);
            experiment.setArguments(arguments);
            experiments.add(experiment);
        });
        layer.setExperiments(experiments);
        List<Layer> layerList = Lists.newArrayList();
        layerList.add(layer);
        boolean result = remoteDayuABService.save(senceId, "计划发布", layerList);
        if (!result) {
            throw new BizException("大禹系统创建实验失败");
        }
        //创建完成后,需要获取一下对应的信息返填回对应的地方
        List<Layer> resultList = remoteDayuABService.getLayers(senceId);
        //目前奇货创建的只有一层layer
        Layer layerRe = resultList.get(0);
        List<Experiment> experimentList = layerRe.getExperiments();
        experimentList.stream().forEach(experiment -> {
            QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
            detailEntity.setExperimentId(experiment.getId());
            detailEntity.setPlanCode(experiment.getArguments().get("planCode"));
            qihoTestPlanDetailMapper.updateByCode(detailEntity);
        });
        return true;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public int saveTestPlan(TestPlanDto planDto) throws BizException {
        if (null == planDto.getId()) {
            return this.addTestPlan(planDto);
        } else {
            return this.updateTestPlan(planDto);
        }
    }

    //修改测试计划
    private int updateTestPlan(TestPlanDto planDto) throws BizException {
        QihoTestPlanEntity oldEntity = qihoTestPlanMapper.selectById(planDto.getId());
        List<String> oldCodeList = Splitter.on(",").splitToList(oldEntity.getPlanCode());
        QihoTestPlanEntity entity = BeanUtils.copy(planDto, QihoTestPlanEntity.class);
        validateTestPlan(entity);
        entity.setPlanStatus(PlanStatusEnum.TO_PUBLISH.getCode());
        StringBuilder planCodeSb = new StringBuilder();
        //创建详情信息
        planDto.getDetailDtoList().stream().forEach(detailDto -> {
            //code生成规则为:planId_priceId_detailId_skinId
            Map<String, Long> param = detailDto.getParam();
            StringBuilder sb = new StringBuilder();
            sb.append(entity.getId()).append(suffix).append(param.get(MetadataTypeEnum.PRICE.getCode())).append(suffix)
                .append(param.get(MetadataTypeEnum.DETAIL.getCode())).append(suffix)
                .append(param.get(MetadataTypeEnum.SKIN.getCode()));
            planCodeSb.append(sb).append(",");
            //如果包含,直接更新
            if (oldCodeList.contains(sb.toString())) {
                QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                detailEntity.setFlowPercent(detailDto.getFlowPercent());
                detailEntity.setPlanCode(sb.toString());
                qihoTestPlanDetailMapper.updateByCode(detailEntity);
            } else {
                param.entrySet().stream().forEach(entry -> {
                    QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                    detailEntity.setPlanCode(sb.toString());
                    detailEntity.setPlanId(entity.getId());
                    detailEntity.setMetadataId(entry.getValue());
                    detailEntity.setFlowPercent(detailDto.getFlowPercent());
                    detailEntity.setMetadataKey(entry.getKey());
                    qihoTestPlanDetailMapper.insert(detailEntity);
                });
            }
        });
        List<String> newCodeList = Splitter.on(",").trimResults().splitToList(planCodeSb);
        oldCodeList.stream().forEach(code -> {
            if (!newCodeList.contains(code)) {
                qihoTestPlanDetailMapper.deleteByCode(code);
            }
        });
        entity.setPlanCode(planCodeSb.substring(0, planCodeSb.length() - 1));
        qihoTestPlanMapper.update(entity);
        return 1;
    }

    //新增测试计划
    private int addTestPlan(TestPlanDto planDto) throws BizException {
        QihoTestPlanEntity entity = BeanUtils.copy(planDto, QihoTestPlanEntity.class);
        validateTestPlan(entity);
        entity.setPlanStatus(PlanStatusEnum.TO_PUBLISH.getCode());
        qihoTestPlanMapper.insert(entity);
        StringBuilder planCodeSb = new StringBuilder();
        //创建详情信息
        planDto.getDetailDtoList().stream().forEach(detailDto -> {
            //code生成规则为:planId_priceId_detailId_skinId
            Map<String, Long> param = detailDto.getParam();
            StringBuilder sb = new StringBuilder();
            sb.append(entity.getId()).append(suffix).append(param.get(MetadataTypeEnum.PRICE.getCode())).append(suffix)
                .append(param.get(MetadataTypeEnum.DETAIL.getCode())).append(suffix)
                .append(param.get(MetadataTypeEnum.SKIN.getCode()));
            planCodeSb.append(sb).append(",");
            param.entrySet().stream().forEach(entry -> {
                QihoTestPlanDetailEntity detailEntity = new QihoTestPlanDetailEntity();
                detailEntity.setFlowPercent(detailDto.getFlowPercent());
                detailEntity.setPlanCode(sb.toString());
                detailEntity.setPlanId(entity.getId());
                detailEntity.setMetadataKey(entry.getKey());
                detailEntity.setMetadataId(entry.getValue());
                qihoTestPlanDetailMapper.insert(detailEntity);
            });
        });
        entity.setPlanCode(planCodeSb.substring(0, planCodeSb.length() - 1));
        qihoTestPlanMapper.update(entity);
        return 1;
    }

    @Override
    public TestPlanDto queryTestPlanById(Long planId) {
        QihoTestPlanEntity entity = qihoTestPlanMapper.selectById(planId);
        TestPlanDto dto = BeanUtils.copy(entity, TestPlanDto.class);
        List<TestPlanDetailDto> list = Lists.newArrayList();
        List<String> codeList = Splitter.on(",").trimResults().splitToList(entity.getPlanCode());
        codeList.stream().forEach(code -> {
            List<QihoTestPlanDetailEntity> detailList = qihoTestPlanDetailMapper.selectListByCode(code);
            TestPlanDetailDto detailDto = new TestPlanDetailDto();
            detailDto.setFlowPercent(detailList.get(0).getFlowPercent());
            Map<String, Long> map = Maps.newHashMap();
            detailList.forEach(e -> map.put(e.getMetadataKey(), e.getMetadataId()));
            detailDto.setParam(map);
            list.add(detailDto);
        });
        dto.setDetailDtoList(list);
        return dto;
    }

    @Override
    public TestPlanStrategyDetailDto queryTestStrategyByItemIdAndUser(Long itemId, String acUserId) {
        TestPlanStrategyDetailDto resultDto = new TestPlanStrategyDetailDto();
        try {
            //根据ItemId查询是否有效的活动信息
            QihoTestPlanEntity entity = qihoTestPlanMapper.selectValidPlanByItemId(itemId);
            if (null == entity) {
                return null;
            }
            //如果有效的活动
            DayuResult handleResult = dayuClient
                .handleRequest("scene:" + entity.getSenceId(), Long.valueOf(acUserId), ArgumentType.CONSUMER_ID);
            if (null == handleResult) {
                logger.warn("TestPlanServiceImpl call dayuClient result is null, acUserId = {},sceneId = {}", acUserId,
                    entity.getSenceId());
                return null;
            }
            Map<String, String> arguments = handleResult.getArguments();
            String planCode = arguments.get("planCode");
            if (StringUtils.isBlank(planCode)) {
                return null;
            }
            //校验一下两边数据是否一致
            List<String> planCodeList = Splitter.on(",").trimResults().splitToList(entity.getPlanCode());
            if (!planCodeList.contains(planCode)) {
                return null;
            }
            //根据planCode返回皮肤信息等
            resultDto.setPlanId(entity.getId());
            resultDto.setPlanCode(planCode);
            List<QihoTestPlanDetailEntity> detailEntityList = qihoTestPlanDetailMapper.selectListByCode(planCode);
            detailEntityList.stream().forEach(detailEntity -> {
                if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.SKIN.getCode())) {
                    QihoTestMetadataEntity testMetadataEntity = qihoTestMetadataMapper
                        .selectById(detailEntity.getMetadataId());
                    resultDto.setSkinId(Long.valueOf(testMetadataEntity.getMetadataValue()));
                    resultDto.setSkinType(testMetadataEntity.getSkinType());
                }
            });
        } catch (Exception e) {
            logger.error("TestPlanServiceImpl call queryTestStrategyByItemIdAndUser error,itemId={},userId={}", itemId,
                acUserId, e);
            return null;
        }
        return resultDto;
    }

    @Override
    public TestPlanStrategyDetailDto queryStrategyDetailByPlanCode(String planCode) {
        TestPlanStrategyDetailDto dto = new TestPlanStrategyDetailDto();
        dto.setPlanCode(planCode);
        List<QihoTestPlanDetailEntity> detailEntityList = qihoTestPlanDetailMapper.selectListByCode(planCode);
        detailEntityList.stream().forEach(detailEntity -> {
            dto.setPlanId(detailEntity.getPlanId());
            QihoTestMetadataEntity testMetadataEntity = qihoTestMetadataMapper.selectById(detailEntity.getMetadataId());
            //如果是价格
            if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.PRICE.getCode())) {
                dto.setPriceInfo(testMetadataEntity.getMetadataValue());
            }
            if (detailEntity.getMetadataKey().equals(MetadataTypeEnum.DETAIL.getCode())) {
                QihoMetadataDetailEntity e = qihoMetadataDetailMapper
                    .selectById(Long.valueOf(testMetadataEntity.getMetadataValue()));
                dto.setDetailText(e.getDetailText());
            }
        });
        return dto;
    }

    private void validateTestPlan(QihoTestPlanEntity entity) throws BizException {
        validateTestPlanName(entity);
        validateTestPlanTime(entity);
    }

    private void validateTestPlanTime(QihoTestPlanEntity entity) throws BizException {
        //校验活动在同一时间段内有没有有效数据
        Map<String, Object> map = Maps.newHashMap();
        map.put("itemId", entity.getItemId());
        map.put("startTime", entity.getStartTime());
        map.put("endTime", entity.getEndTime());
        List<QihoTestPlanEntity> existList = qihoTestPlanMapper.selectExistTestPlanByItemId(map);
        if (CollectionUtils.isNotEmpty(existList)) {
            if (null == entity.getId() || 0 == entity.getId()) {
                throw new BizException("商品在当前时间段内已存在测试计划,计划名称名称:" + existList.get(0).getPlanName());
            }
            for (QihoTestPlanEntity e : existList) {
                if (!e.getId().equals(entity.getId())) {
                    throw new BizException("商品在当前时间段内已存在测试计划,计划名称名称:" + e.getPlanName());
                }
            }
        }
    }

    private void validateTestPlanName(QihoTestPlanEntity entity) throws BizException {
        //根据名字获取活动信息
        Map<String, Object> map = Maps.newHashMap();
        map.put("planName", entity.getPlanName());
        List<QihoTestPlanEntity> list = qihoTestPlanMapper.selectListByField(map);
        if (CollectionUtils.isNotEmpty(list)) {
            if (null == entity.getId() || 0 == entity.getId()) {
                throw new BizException("测试计划名称已存在");
            }
            for (QihoTestPlanEntity e : list) {
                if (!e.getId().equals(entity.getId())) {
                    throw new BizException("测试计划名称已存在");
                }
            }
        }
    }

}
