package com.qiho.center.biz.service.impl.advert;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.CollectionAdvertDto;
import com.qiho.center.biz.service.advert.CollectionAdvertService;
import com.qiho.center.common.daoh.qiho.advert.BaiqiCollectionAdvertMapper;
import com.qiho.center.common.daoh.qiho.page.CollPageMapper;
import com.qiho.center.common.entityd.qiho.advert.BaiqiCollectionAdvertEntity;
import com.qiho.center.common.entityd.qiho.page.CollPageEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-09-12
 */
@Service
public class CollectionAdvertServiceImpl implements CollectionAdvertService {


    @Autowired
    private BaiqiCollectionAdvertMapper baiqiCollectionAdvertMapper;

    @Autowired
    private CollPageMapper collPageMapper;

    /**
     * 保存集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    @Override
    public ResultDto<Boolean> insertCollectionAdvert(CollectionAdvertDto collectionAdvert) {

        BaiqiCollectionAdvertEntity entity = new BaiqiCollectionAdvertEntity();
        entity.setCollectionId(collectionAdvert.getCollectionId());
        entity.setAdvertIds(JSONObject.toJSONString(collectionAdvert.getAdvertIds()));
        entity.setOpeartor(collectionAdvert.getOpeartor());

        int row = baiqiCollectionAdvertMapper.insert(entity);
        return ResultDto.successResult(row == 1);
    }

    /**
     * 根据集合页id查找 集合页广告位关联记录
     * @param collectionId
     * @return
     */
    @Override
    public CollectionAdvertDto findByCollectionId(Long collectionId) {

        BaiqiCollectionAdvertEntity entity = baiqiCollectionAdvertMapper.findByCollectionId(collectionId);
        if (entity == null) {
            return null;
        }

        CollectionAdvertDto collectionAdvert = BeanUtils.copy(entity, CollectionAdvertDto.class);
        collectionAdvert.setAdvertIds(JSONObject.parseArray(entity.getAdvertIds(), Long.class));

        return collectionAdvert;
    }


    /**
     * 根据集合页广告位id查找集合页广告位关联记录
     * @param id
     * @return
     */
    @Override
    public CollectionAdvertDto findById(Long id) {
        BaiqiCollectionAdvertEntity entity = baiqiCollectionAdvertMapper.findByCollectionId(id);
        if (entity == null) {
            return null;
        }

        CollectionAdvertDto collectionAdvert = BeanUtils.copy(entity, CollectionAdvertDto.class);
        collectionAdvert.setAdvertIds(JSONObject.parseArray(entity.getAdvertIds(), Long.class));

        CollPageEntity collectionPageEntity = collPageMapper.findById(entity.getCollectionId());
        if (collectionPageEntity != null) {
            collectionAdvert.setCollectionName(collectionPageEntity.getPageName());
        }

        return collectionAdvert;
    }

    /**
     * 删除集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    @Override
    public ResultDto<Boolean> deletedCollectionAdvert(CollectionAdvertDto collectionAdvert) {
        BaiqiCollectionAdvertEntity entity = BeanUtils.copy(collectionAdvert, BaiqiCollectionAdvertEntity.class);
        int row = baiqiCollectionAdvertMapper.deleteById(entity);

        return ResultDto.successResult(row == 1);
    }

    /**
     * 修改集合页广告位记录
     * @param collectionAdvert
     * @return
     */
    @Override
    public ResultDto<Boolean> updateCollectionAdvert(CollectionAdvertDto collectionAdvert) {
        BaiqiCollectionAdvertEntity entity = BeanUtils.copy(collectionAdvert, BaiqiCollectionAdvertEntity.class);
        entity.setAdvertIds(JSONObject.toJSONString(collectionAdvert.getAdvertIds()));
        int row = baiqiCollectionAdvertMapper.updateById(entity);
        return ResultDto.successResult(row == 1);
    }

    /**
     * 查询所有的集合页广告位记录
     * @return
     */
    @Override
    public List<CollectionAdvertDto> listAllCollectionAdvert() {
        List<BaiqiCollectionAdvertEntity> entityList = baiqiCollectionAdvertMapper.listAllCollectionAdvert();
        if (CollectionUtils.isEmpty(entityList)) {
            return Lists.newArrayList();
        }

        // 查询集合页名称
        List<Long> collectionIds = entityList.stream().map(BaiqiCollectionAdvertEntity::getCollectionId).collect(Collectors.toList());
        List<CollPageEntity> collPageEntities = collPageMapper.listByIds(collectionIds);
        Map<Long, String> collectionPageMap = collPageEntities.stream()
                .collect(Collectors.toMap(CollPageEntity::getId, CollPageEntity::getPageName));

        List<CollectionAdvertDto> list = entityList.stream().map(e -> {
            CollectionAdvertDto collectionAdvert = BeanUtils.copy(e, CollectionAdvertDto.class);
            collectionAdvert.setAdvertIds(JSONObject.parseArray(e.getAdvertIds(), Long.class));
            collectionAdvert.setCollectionName(collectionPageMap.get(e.getCollectionId()));
            return collectionAdvert;
        }).collect(Collectors.toList());

        return list;
    }






}
