package com.qiho.center.biz.service.impl.amap;

import com.alibaba.fastjson.JSON;
import com.qiho.center.biz.service.amap.AmapApiService;
import com.qiho.center.api.dto.amap.BaiqiAmapDto;
import com.qiho.center.api.dto.amap.BaiqiAmapTipDto;
import com.qiho.center.common.util.HttpClientUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

/**
 * @author: wangjin
 * @create 2018-04-03 09:18
 **/
@Service("amapApiService")
public class AmapApiServiceImpl implements AmapApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmapApiServiceImpl.class);

    @Value("${qiho.amap.tips.url}")
    private String amapUrl;

    @Value("${qiho.amap.tips.key}")
    private String amapKey;

    @Override
    public List<BaiqiAmapTipDto> getAmapTipList(String keywords, String city) {

        String cityCode = "";

        if (Objects.isNull(keywords)) {
            keywords = "";
        }

        if (Objects.isNull(city)) {
            city = "";
        }
        //判断city是否是行政编码
        else if(StringUtils.isNumeric(city) && city.length() == 6){
            cityCode = city.substring(0,4);
        }

        String url = "";

        try {
            url = amapUrl + "?key=" + amapKey + "&keywords=" + URLEncoder.encode(keywords, "utf-8") + "&city=" + URLEncoder.encode(city, "utf-8");

            //获取结果
            String result = HttpClientUtil.sendGet(url);

            if (StringUtils.isBlank(result)) {
                return Collections.emptyList();
            }

            //转换数据
            BaiqiAmapDto amapDto = JSON.parseObject(result, BaiqiAmapDto.class);

            //判断获取失败
            if (Objects.isNull(amapDto) || amapDto.getStatus() == 0) {
                return Collections.emptyList();
            }

            //过滤adcode为空的提示地址 & 过滤不是本市的地址
            Iterator iterator = amapDto.getTips().iterator();
            while (iterator.hasNext()) {
                BaiqiAmapTipDto baiqiAmapTipDto = (BaiqiAmapTipDto) iterator.next();
                if ("[]".equals(baiqiAmapTipDto.getAdcode())) {
                    iterator.remove();
                    continue;
                }

                //如果是城市编码，则排除非本市地址
                if(StringUtils.isNotBlank(city) && StringUtils.isNotBlank(cityCode)
                        &&!cityCode.equals(baiqiAmapTipDto.getAdcode().substring(0,4))){
                    iterator.remove();
                }
            }
            return amapDto.getTips();
        } catch (Exception e) {
            LOGGER.warn("调用高德地图接口失败, URL:{}", url, e);
        }

        return Collections.emptyList();
    }
}
