package com.qiho.center.biz.service.impl.area;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import com.qiho.center.api.dto.area.AddressDto;
import com.qiho.center.biz.service.area.AddressService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.area.BaiqiAddressMapper;
import com.qiho.center.common.entity.area.BaiqiAddressEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @author chensong
 * @create 2018-01-25 11:45
 **/
@Service
public class AddressServiceImpl implements AddressService {

    @Autowired
    private BaiqiAddressMapper baiqiAddressMapper;

    @Override
    public List<AddressDto> findByUserId(Long userId) {
        BaiqiAddressEntity param = new BaiqiAddressEntity();
        param.setUserId(userId);
        List<BaiqiAddressEntity> entityList = baiqiAddressMapper.findByParam(param);
        return BeanUtils.copyList(entityList, AddressDto.class);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean createAddress(AddressDto dto) {

        // 如果插入的地址设置了默认 则将之前的地址取消默认
        if (dto.getDefaulted()) {
            baiqiAddressMapper.cancelDefault(dto.getUserId());
        }
        baiqiAddressMapper.insert(BeanUtils.copy(dto, BaiqiAddressEntity.class));
        return Boolean.TRUE;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean deleteAddress(AddressDto dto) {
        BaiqiAddressEntity entity = baiqiAddressMapper.findById(dto.getId());
        baiqiAddressMapper.delete(dto.getId());
        // 如果删除的是默认地址 则将最新的一条设为默认
        if (entity.getDefaulted()) {
            BaiqiAddressEntity param = new BaiqiAddressEntity();
            param.setUserId(dto.getUserId());
            List<BaiqiAddressEntity> entities = baiqiAddressMapper.findByParam(param);
            if (CollectionUtils.isNotEmpty(entities)) {
                baiqiAddressMapper.setDefault(entities.get(0).getId());
            }
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_QIHO,rollbackFor = Exception.class)
    public Boolean alterDefault(AddressDto dto) {
        baiqiAddressMapper.cancelDefault(dto.getUserId());
        baiqiAddressMapper.setDefault(dto.getId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateAddress(AddressDto dto) {
        // 判断该地址是否设置成默认地址
        if (dto.getDefaulted()) {
            baiqiAddressMapper.cancelDefault(dto.getUserId());
        }
        baiqiAddressMapper.updateAddress(BeanUtils.copy(dto, BaiqiAddressEntity.class));
        return Boolean.TRUE;
    }

    @Override
    public AddressDto findById(Long addressId) {
        return BeanUtils.copy(baiqiAddressMapper.findById(addressId), AddressDto.class);
    }

    @Override
    public AddressDto findByDefaultOrNew(Long userId) {
        BaiqiAddressEntity entity = baiqiAddressMapper.findByDefault(userId);
        if (!ObjectUtils.isEmpty(entity)){
            return BeanUtils.copy(entity,AddressDto.class);
        }else {
            return BeanUtils.copy(baiqiAddressMapper.findByNew(userId),AddressDto.class);
        }
    }

    @Override
    public AddressDto findByIdAndUserId(AddressDto dto) {
        BaiqiAddressEntity entity = BeanUtils.copy(dto,BaiqiAddressEntity.class);
        return BeanUtils.copy(baiqiAddressMapper.findByIdAndUserId(entity),AddressDto.class);
    }


}
