package com.qiho.center.biz.service.impl.bizlog;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bizlog.QihoBizlogDto;
import com.qiho.center.api.params.bizlog.QihoBizlogParams;
import com.qiho.center.biz.service.bizlog.QihoBizLogService;
import com.qiho.center.common.daoh.qiho.QihoBizLogMapper;
import com.qiho.center.common.entityd.qiho.bizlog.QihoBizLogEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by sunchangji on 2017/11/23.
 */
@Service("qihoBizLogService")
public class QihoBizLogServiceImpl implements QihoBizLogService {

    @Resource
    private QihoBizLogMapper qihoBizLogMapper;

    @Override
    public Long insertBizLog(QihoBizLogEntity bizLogEntity) {
        qihoBizLogMapper.insertBizLog(bizLogEntity);
        return bizLogEntity.getId();
    }

    @Override
    public Boolean updateStatusById(Long id, Integer bizStatus) {
        return qihoBizLogMapper.updateStatusById(id, bizStatus) == 1;
    }

    @Override
    public PagenationDto<QihoBizlogDto> findPage(QihoBizlogParams bizlogParams) {
        PagenationDto<QihoBizlogDto> page = new PagenationDto<>();
        List<QihoBizLogEntity> qihoBizLogEntities = qihoBizLogMapper.findPage(bizlogParams);
        page.setList(BeanUtils.copyList(qihoBizLogEntities, QihoBizlogDto.class));
        page.setTotal(qihoBizLogMapper.totalCount(bizlogParams));
        return page;
    }


}
