package com.qiho.center.biz.service.impl.data;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.GoodsDataDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemCostDto;
import com.qiho.center.api.params.data.GoodsQueryParam;
import com.qiho.center.api.params.data.ItemDataQueryParam;
import com.qiho.center.api.params.item.QihoItemParam;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.data.GoodsDataService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qihostatistics.data.QihoItemDailyConsumeMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSimpleEntity;
import com.qiho.center.common.entityd.qiho.data.QihoItemDailyConsumeEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by xianhongwei on 2018/1/3.
 */
@Service
public class GoodsDataServiceImpl implements GoodsDataService {

    @Autowired
    private QihoItemDailyConsumeMapper qihoItemDailyConsumeMapper;

    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Autowired
    private ItemService itemService;

    @Override
    public PagenationDto<GoodsDataDto> getGoodsData(GoodsQueryParam param) {
        PagenationDto<GoodsDataDto> pagenationDto = new PagenationDto<>();
        String name = param.getName();
        if (param.getItemId() != null) {
            param.setItemIds(Lists.newArrayList(param.getItemId()));
        }
        if (StringUtils.isNotBlank(name)) {
            QihoItemParam qihoItemParam = new QihoItemParam();
            qihoItemParam.setItemName(name);
            Long merchantId = param.getMerchantId();
            qihoItemParam.setMerchantId(merchantId);
            List<QihoItemSimpleEntity> itemSimpleEntities = qihoItemDAO.selectByParam(qihoItemParam);
            if (CollectionUtils.isEmpty(itemSimpleEntities)) {
                pagenationDto.setList(Collections.emptyList());
                pagenationDto.setTotal(0);
                return pagenationDto;
            }
            List<Long> itemIds = itemSimpleEntities.stream().filter(e -> e.getMerchantId().equals(merchantId))
                .map(QihoItemSimpleEntity::getItemId).collect(Collectors.toList());
            param.setItemIds(itemIds);

        }
        Integer count = qihoItemDailyConsumeMapper.countItemData(param);
        List<QihoItemDailyConsumeEntity> list = qihoItemDailyConsumeMapper.getItemDataByParam(param);
        if (CollectionUtils.isEmpty(list)) {
            pagenationDto.setTotal(0);
            pagenationDto.setList(Collections.emptyList());
            return pagenationDto;
        }
        List<Long> getItemIds = list.stream().map(QihoItemDailyConsumeEntity::getItemId).collect(Collectors.toList());
        Map<Long, QihoItemEntity> map = itemService.selectByIdList(getItemIds);
        List<GoodsDataDto> goodsDataDtoList = list.stream().map(e -> entityToDto(e, map)).collect(Collectors.toList());
        pagenationDto.setList(goodsDataDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    private GoodsDataDto entityToDto(QihoItemDailyConsumeEntity entity, Map<Long, QihoItemEntity> map) {
        GoodsDataDto goodsDataDto = BeanUtils.copy(entity, GoodsDataDto.class);

        if (map.containsKey(entity.getItemId())) {
            goodsDataDto.setItemName(map.get(entity.getItemId()).getItemName());
        }

        DecimalFormat twoDecimalPlaces = new DecimalFormat("0.00");
        goodsDataDto.setConsumeTotal(twoDecimalPlaces.format(entity.getConsumeTotal() * 1.0 / 100));
        if (entity.getClickCount() != 0) {
            Double clickFlod = entity.getConsumeTotal() * 1.0 / entity.getClickCount() / 100;
            goodsDataDto.setClickFlod(twoDecimalPlaces.format(clickFlod));
            Double placeAnOrderRate = entity.getSalesVolume() * 1.0 / entity.getClickCount() * 100;
            goodsDataDto.setPlaceAnOrderRate(twoDecimalPlaces.format(placeAnOrderRate) + "%");
        }
        if (entity.getSalesVolume() != 0) {
            Double placeAnOrderCost = entity.getConsumeTotal() * 1.0 / entity.getSalesVolume() / 100;
            goodsDataDto.setPlaceAnOrderCost(twoDecimalPlaces.format(placeAnOrderCost));
        }
        if (entity.getExposureCount() != 0) {
            Double clickRate = entity.getClickCount() * 1.0 / entity.getExposureCount() * 100;
            goodsDataDto.setClickRate(twoDecimalPlaces.format(clickRate) + "%");
        }
        return goodsDataDto;
    }

    @Override
    public PagenationDto<ItemCostDto> queryPage(ItemDataQueryParam param) {
        PagenationDto<ItemCostDto> page = new PagenationDto<>();
        Map<Long, String> itemNameMap = Maps.newHashMap();
        List<Long> itemIds = Lists.newArrayList();
        // 通过参数路由
        if (StringUtils.isNotBlank(param.getItemName()) || param.getItemId() != null) {
            QihoItemEntity itemEntity = new QihoItemEntity();
            itemEntity.setId(param.getItemId());
            itemEntity.setItemName(param.getItemName());
            List<QihoItemEntity> itemList = qihoItemDAO.queryItemByParam(itemEntity);
            if (CollectionUtils.isEmpty(itemList)) {
                page.setTotal(0);
                page.setList(Lists.newArrayList());
                return page;
            }
            itemIds = itemList.stream().map(e -> {
                itemNameMap.put(e.getId(), e.getItemName());
                return e.getId();
            }).collect(Collectors.toList());
        }

        // 去消耗表捞数据
        GoodsQueryParam queryParam = new GoodsQueryParam();
        queryParam.setStartTime(param.getStartTime());
        queryParam.setEndTime(param.getEndTime());
        queryParam.setOffset(param.getOffset());
        queryParam.setMax(param.getMax());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            queryParam.setItemIds(itemIds);
        }
        Integer total = qihoItemDailyConsumeMapper.countItemData(queryParam);
        List<QihoItemDailyConsumeEntity> consumeList = qihoItemDailyConsumeMapper.getItemDataByParam(queryParam);
        page.setTotal(total);
        if (total.intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }

        if (itemNameMap.size() == 0) {
            List<Long> ids = consumeList.stream().map(QihoItemDailyConsumeEntity::getItemId)
                .collect(Collectors.toList());
            qihoItemDAO.queryItemByIds(ids).stream().forEach(e -> itemNameMap.put(e.getId(), e.getItemName()));
        }

        // 类型转换
        List<ItemCostDto> list = Lists.transform(consumeList, consume -> {
            ItemCostDto itemCost = new ItemCostDto();
            itemCost.setItemId(consume.getItemId());
            itemCost.setItemName(itemNameMap.get(consume.getItemId()));
            itemCost.setClick(consume.getClickCount());
            itemCost.setExpose(consume.getExposureCount());
            itemCost.setCost(consume.getConsumeTotal());
            return itemCost;
        });
        page.setList(list);
        return page;
    }

}
