package com.qiho.center.biz.service.impl.data;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.StatisticsPagenationDto;
import com.qiho.center.api.dto.data.MerchantDaliyOrderDto;
import com.qiho.center.api.dto.data.MerchantOrderStatisticsDto;
import com.qiho.center.api.params.data.MerchantOrderQueryParam;
import com.qiho.center.biz.service.data.MerchantDaliyOrderService;
import com.qiho.center.common.daoh.qihostatistics.data.BaiqiDailyMerchantOrderMapper;
import com.qiho.center.common.entityd.qihostatistics.BaiqiDailyMerchantOrderEntity;
import com.qiho.center.common.entityd.qihostatistics.MerchantDailyStatisticsEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @author chensong
 * @create 2018-08-13
 */
@Service
public class MerchantDaliyOrderServiceImpl implements MerchantDaliyOrderService {

    @Autowired
    private BaiqiDailyMerchantOrderMapper baiqiDailyMerchantOrderMapper;

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");

    @Override
    public StatisticsPagenationDto<MerchantDaliyOrderDto, MerchantOrderStatisticsDto> queryPage(MerchantOrderQueryParam param) {

        StatisticsPagenationDto page = new StatisticsPagenationDto();

        // 查询数量
        int count = baiqiDailyMerchantOrderMapper.countByQuery(param);
        page.setTotal(count);
        if (count == 0) {
            return page.emptyPage();
        }

        // 查询数据
        List<BaiqiDailyMerchantOrderEntity> list = baiqiDailyMerchantOrderMapper.listByQuery(param);
        page.setList(convertToDtoList(list));

        // 查询统计数据
        MerchantDailyStatisticsEntity statistics = baiqiDailyMerchantOrderMapper.staticticsByQuery(param);
        page.setStatistics(calcTotalData(statistics));

        return page;
    }

    /**
     * 类型转换
     * @param list
     * @return
     */
    private List<MerchantDaliyOrderDto> convertToDtoList(List<BaiqiDailyMerchantOrderEntity> list){
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<MerchantDaliyOrderDto> dtoList = Lists.newArrayList();
        for (BaiqiDailyMerchantOrderEntity e : list) {
            MerchantDaliyOrderDto dto = BeanUtils.copy(e, MerchantDaliyOrderDto.class);
            dto.setOrderTimeStr(DATE_TIME_FORMATTER.format(e.getOrderTime()));
            dtoList.add(dto);
        }
        return dtoList;
    }

    /**
     * 计算总计数据
     * @param statistics
     * @return
     */
    private MerchantOrderStatisticsDto calcTotalData(MerchantDailyStatisticsEntity statistics){
        MerchantOrderStatisticsDto dto = BeanUtils.copy(statistics, MerchantOrderStatisticsDto.class);

        if (statistics.getOrderCtSum() == 0) {
            dto.setOrderSdRateAvg(new BigDecimal(0));
            dto.setOrderCostAvg(0);
        } else {
            // 平均出单率 = 出单数/总订单数
            dto.setOrderSdRateAvg(new BigDecimal(statistics.getOrderSdCtSum()).divide(
                    new BigDecimal(statistics.getOrderCtSum()) , 4, BigDecimal.ROUND_HALF_UP));
            // 平均消耗 = 总消耗/总订单数
            dto.setOrderCostAvg(new BigDecimal(statistics.getAdConsumeSum()).divide(
                    new BigDecimal(statistics.getOrderCtSum()), 0, BigDecimal.ROUND_HALF_UP
            ).intValue());
        }

        if (statistics.getOrderSdCtSum() == 0) {
            dto.setOrderSngRateAvg(new BigDecimal(0));
        } else {
            // 平均签收率 = 签收数/出单数
            dto.setOrderSngRateAvg(new BigDecimal(statistics.getOrderSngCtSum()).divide(
                    new BigDecimal(statistics.getOrderSdCtSum()) , 4, BigDecimal.ROUND_HALF_UP));
        }

        return dto;
    }




}
