package com.qiho.center.biz.service.impl.edb;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.biz.service.EdbApiService;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.EdbLib;

/**
 * Author: zhanghuifeng
 * Date:   10:10 2017/11/14
 */
@Service
public class EdbApiServiceImpl implements EdbApiService {

	@Resource
	private EdbLib edbLib;

	private static final Logger LOG = LoggerFactory.getLogger(EdbApiServiceImpl.class);

	@Override
	public List<ErpLogisticsSyncDto> edbTradeGet(int pageNo, String pageSize, String beginTime, String endTime) {
		Map<String, String> params = edbLib.edbGetCommonParams("edbTradeGet");
		params.put("page_no", String.valueOf(pageNo));
		params.put("page_size", pageSize);
		params.put("begin_time", beginTime);
		params.put("end_time", endTime);
		params.put("date_type","发货日期");
		String res = edbLib.edbRequstPost(params);
		if (StringUtils.isBlank(res)) {
			return Collections.emptyList();
		}
		JSONObject json = JSONObject.parseObject(res);

		JSONObject successList = json.getJSONObject("Success");
		if (successList == null) {
			return Collections.emptyList();
		}
		Integer totalResults = successList.getInteger("total_results");
		if (totalResults == 0) {
			return Collections.emptyList();
		}

		String items = successList.getJSONObject("items").getString("item");
		return getLogisticsOrderDtoList(items);

	}

	private List<ErpLogisticsSyncDto> getLogisticsOrderDtoList(String items) {
		List<ErpLogisticsSyncDto> list = Lists.newArrayList();
		try {
			if (StringUtils.isBlank(items)) {
				return Collections.emptyList();
			}
			JSONArray temp = JSON.parseArray(items);
			// 无待同步物流订单信息
			if (CollectionUtils.isEmpty(temp)) {
				return Collections.emptyList();
			}
			for (int j = 0; j < temp.size(); j++) {
				JSONObject t = temp.getJSONObject(j);
				ErpLogisticsSyncDto queryLogisticsReturnDto = new ErpLogisticsSyncDto();
				queryLogisticsReturnDto.setTid(String.valueOf(t.get("out_tid")));
				queryLogisticsReturnDto.setLogisticsNo(String.valueOf(t.get("express_no")));
				queryLogisticsReturnDto.setLogisticsCode(String.valueOf(t.get("express_coding")));
				queryLogisticsReturnDto.setLogisticsName(String.valueOf(t.get("express")));
				queryLogisticsReturnDto.setLogisticsNameErp(String.valueOf(t.get("express")));
				LogisticsNameEnum logisticsName = LogisticsNameEnum.getByName(queryLogisticsReturnDto.getLogisticsName());
				if(logisticsName != null){
					queryLogisticsReturnDto.setLogisticsCode(logisticsName.getCode());
				}
				list.add(queryLogisticsReturnDto);
			}
		} catch (Exception e) {
			AppLogUtil.warn(LOG, "同步物流订单失败", e);
			return Collections.emptyList();
		}
		return list;
	}
}
