package com.qiho.center.biz.service.impl.logistics;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.qiho.center.api.enums.logistics.LogisticsExpressPlatformEnum;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.service.logistics.ExpressSubscribeService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiExpressSubscribeMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressSubscribeEntity;
import com.qiho.center.common.util.BaiqiCollectionUtils;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @Author chensong
 * @Create 2019-02-18
 */
@Service
public class ExpressSubscribeServiceImpl implements ExpressSubscribeService {

    private static final Logger logger = LoggerFactory.getLogger(ExpressSubscribeServiceImpl.class);

    @Autowired
    private BaiqiExpressSubscribeMapper baiqiExpressSubscribeMapper;

    @Override
    public void saveSubscribeData(List<LogisticsOrderDo> list, LogisticsExpressPlatformEnum platform) {
        if (CollectionUtils.isEmpty(list) || platform == null) {
            return;
        }

        // 订阅数据分批处理
        List<List<LogisticsOrderDo>> blockList = BaiqiCollectionUtils.subListBlock(list, 300);
        for (List<LogisticsOrderDo> block : blockList) {
            try {
                dealSubscribeData(block, platform);
            } catch (Exception e) {
                logger.error("ExpressSubscribeServiceImpl.dealSubscribeData error! ", e);
            }
        }
    }

    /**
     * 处理保存订阅信息
     *
     * @param list
     * @param platform
     */
    private void dealSubscribeData(List<LogisticsOrderDo> list, LogisticsExpressPlatformEnum platform){
        List<BaiqiExpressSubscribeEntity> subscribeData = list.stream().map(logisticsOrder -> {
            BaiqiExpressSubscribeEntity subscribeEntity = BeanUtils.copy(logisticsOrder, BaiqiExpressSubscribeEntity.class);
            subscribeEntity.setPlatform(platform.getNum());
            return subscribeEntity;
        }).collect(Collectors.toList());

        // 查找已经存在订单的订阅信息
        List<String> orderIds = list.stream().map(LogisticsOrderDo::getOrderId).collect(Collectors.toList());
        List<String> existOrderIds = baiqiExpressSubscribeMapper.selectByOrderIds(orderIds);
        if (CollectionUtils.isEmpty(existOrderIds)) {
            List<BaiqiExpressSubscribeEntity> filterData =  subscribeData.stream().filter(e -> StringUtils.isNotBlank(e.getOrderId())).collect(Collectors.toList());
            baiqiExpressSubscribeMapper.batchInsertExpressSubscribe(filterData);
            return;
        }

        List<BaiqiExpressSubscribeEntity> insertData = Lists.newArrayList();
        List<BaiqiExpressSubscribeEntity> updateData = Lists.newArrayList();
        subscribeData.forEach(e -> {
            if (existOrderIds.contains(e.getOrderId())) {
                updateData.add(e);
            } else {
                insertData.add(e);
            }
        });

        if (CollectionUtils.isNotEmpty(updateData)) {
            List<BaiqiExpressSubscribeEntity> filterData =  updateData.stream().filter(e -> StringUtils.isNotBlank(e.getOrderId())).collect(
                Collectors.toList());
            baiqiExpressSubscribeMapper.batchUpdateExpressSubscribe(filterData);
        }
        if (CollectionUtils.isNotEmpty(insertData)) {
            List<BaiqiExpressSubscribeEntity> filterData =  insertData.stream().filter(e -> StringUtils.isNotBlank(e.getOrderId())).collect(Collectors.toList());
            baiqiExpressSubscribeMapper.batchInsertExpressSubscribe(filterData);
        }
    }

}
