package com.qiho.center.biz.service.impl.message;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.message.MessageCheckedDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageCheckedPagingParams;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;
import com.qiho.center.biz.service.message.MessageService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.message.MessageCheckedMapper;
import com.qiho.center.common.daoh.qiho.message.MessageNotifyMapper;
import com.qiho.center.common.entityd.qiho.message.MessageCheckedEntity;
import com.qiho.center.common.entityd.qiho.message.MessageNotifyEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: wangjin
 * @create 2018-07-02 15:30
 **/
@Service
public class MessageServiceImpl implements MessageService {

    @Autowired
    private MessageNotifyMapper messageNotifyMapper;

    @Autowired
    private MessageCheckedMapper messageCheckedMapper;

    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;

    @Override
    public int saveMessage(MessageNotifyDto dto) {
        MessageNotifyEntity entity = messageNotifyMapper.findMessageById(dto.getId());
        //新增或修改
        if (ObjectUtils.isEmpty(entity)){
            return messageNotifyMapper.insertMessage(BeanUtils.copy(dto,MessageNotifyEntity.class));
        }else {
            return messageNotifyMapper.updateMessageById(BeanUtils.copy(dto,MessageNotifyEntity.class));
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveAndPublishMessage(MessageNotifyDto dto) {
        MessageNotifyEntity entity = messageNotifyMapper.findMessageById(dto.getId());

        MessageNotifyEntity messageNotifyEntity = BeanUtils.copy(dto,MessageNotifyEntity.class);
        //新增或修改
        if (ObjectUtils.isEmpty(entity)){
            messageNotifyMapper.insertMessage(messageNotifyEntity);
        }else {
            messageNotifyMapper.updateMessageById(messageNotifyEntity);
        }

        List<MerchantSimpleDto> merchantList = qihoMerchantDAO.findAllIdAndNames();
        List<MessageCheckedEntity> list = new ArrayList<>();
        merchantList.stream().forEach(item -> {
            MessageCheckedEntity checkedEntity = new MessageCheckedEntity();
            checkedEntity.setMsgId(messageNotifyEntity.getId());
            checkedEntity.setChecked(0);
            checkedEntity.setMerchantId(item.getId());
            checkedEntity.setTitle(messageNotifyEntity.getTitle());
            list.add(checkedEntity);
        });
        messageCheckedMapper.insertCheckedMessages(list);
        return true;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteMessage(Long id) {
        messageNotifyMapper.deleteMessageById(id);
        messageCheckedMapper.deleteCheckedMessage(id);
        return true;
    }

    @Override
    public MessageNotifyDto findMessageById(Long id) {
        MessageNotifyEntity entity = messageNotifyMapper.findMessageById(id);
        return BeanUtils.copy(entity,MessageNotifyDto.class);
    }

    @Override
    public PagenationDto<MessageNotifyDto> findMessages(MessageNotifyPagingParams params) {
        List<MessageNotifyEntity> list = messageNotifyMapper.findMessages(params);
        PagenationDto<MessageNotifyDto> pagenationDto = new PagenationDto<>();
        if (CollectionUtils.isEmpty(list)){
            return pagenationDto.emptyPage();
        }
        //查询总数
        int count = messageNotifyMapper.countMessage();
        pagenationDto.setTotal(count);
        pagenationDto.setList(BeanUtils.copyList(list,MessageNotifyDto.class));
        return pagenationDto;
    }



    @Override
    public int countCheckedMessage(Long merchantId) {
        return messageCheckedMapper.countCheckedMessage(merchantId);
    }

    @Override
    public MessageNotifyDto findMessageDescription(Long merchantId) {
        MessageCheckedEntity entity = messageCheckedMapper.findCheckedMessageLatest(merchantId);
        if (ObjectUtils.isEmpty(entity)||entity.getChecked()==1){
            return null;
        }else {
            return BeanUtils.copy(messageNotifyMapper.findMessageDescription(entity.getMsgId()),MessageNotifyDto.class);
        }

    }

    @Override
    public PagenationDto<MessageCheckedDto> findCheckedMessages(MessageCheckedPagingParams params) {
        List<MessageCheckedEntity> list = messageCheckedMapper.findCheckedMessages(params);
        PagenationDto<MessageCheckedDto> pagenationDto = new PagenationDto<>();
        if (CollectionUtils.isEmpty(list)){
            return pagenationDto.emptyPage();
        }
        //查询总数
        int count = messageCheckedMapper.countAllCheckedMessage(params.getMerchantId());
        pagenationDto.setTotal(count);
        pagenationDto.setList(BeanUtils.copyList(list,MessageCheckedDto.class));
        return pagenationDto;
    }

    @Override
    public MessageNotifyDto readMessage(Long id, Long merchantId) {
        messageCheckedMapper.updateCheckedMessage(id, merchantId);
        return BeanUtils.copy(messageNotifyMapper.findMessageById(id),MessageNotifyDto.class);
    }
}
