package com.qiho.center.biz.service.impl.operatelog;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.operatelog.BaiqiOperateLogDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.operatelog.BaiqOperateLogParams;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.operatelog.BaiqiOperateLogService;
import com.qiho.center.common.daoh.qiho.operatelog.BaiqiOperateLogMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.operatelog.BaiqiOperateLogEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * Created by sunchangji on 2017/12/28.
 */
@Service("baiqiOperateLogService")
public class BaiqiOperateLogServiceImpl implements BaiqiOperateLogService {

    @Resource
    private BaiqiOperateLogMapper baiqiOperateLogMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;


    @Override
    public Boolean insertLog(BaiqiOperateLogEntity operateLogEntity) {
        return baiqiOperateLogMapper.insertLog(operateLogEntity) == 1;
    }

    @Override
    public PagenationDto<BaiqiOperateLogDto> findLogPage(BaiqOperateLogParams operateLogParams) {
        PagenationDto<BaiqiOperateLogDto> pagenationDto = new PagenationDto<>();
        List<BaiqiOperateLogEntity> logEntities = baiqiOperateLogMapper.findLogPage(operateLogParams);
        if (CollectionUtils.isEmpty(logEntities)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(0);
            return pagenationDto;
        }
        Set<Long> agentIds = new HashSet<>();
        Set<Long> merchantIds = new HashSet<>();
        for (BaiqiOperateLogEntity operateLogEntity : logEntities) {
            int type = operateLogEntity.getRelationType();
            Long relationId = operateLogEntity.getRelationId();
            if (type == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
            } else {
                merchantIds.add(relationId);
            }
        }
        Map<Long, BaiqiAgentEntity> agentMap = baiqiAgentService.findByIdsMap(Lists.newArrayList(agentIds));
        Map<Long, MerchantDto> maerchantMap = merchantService.findByIdList(Lists.newArrayList(merchantIds));
        List<BaiqiOperateLogDto> result = new ArrayList<>();
        for (BaiqiOperateLogEntity entity : logEntities) {
            BaiqiOperateLogDto logDto = BeanUtils.copy(entity, BaiqiOperateLogDto.class);
            int type = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (type == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = agentMap.get(relationId);
                logDto.setRelationName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = maerchantMap.get(relationId);
                logDto.setRelationName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            result.add(logDto);
        }
        int total = baiqiOperateLogMapper.countPage(operateLogParams);
        pagenationDto.setList(result);
        pagenationDto.setTotal(total);
        return pagenationDto;
    }
}
