/**
 * Project Name:qiho-center-biz
 * File Name:ChannelInfoServiceImpl.java
 * Package Name:com.qiho.center.biz.service.impl.order
 * Date:2017年6月6日下午12:24:54
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.biz.service.order.ChannelInfoService;
import com.qiho.center.common.dao.QihoChannelInfoDAO;
import com.qiho.center.common.entity.order.QihoChannelInfoEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * ClassName:ChannelInfoServiceImpl <br/>
 * Date:     2017年6月6日 下午12:24:54 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ChannelInfoServiceImpl implements ChannelInfoService {
    @Autowired
    private QihoChannelInfoDAO qihoChannelInfoDAO;
    
    @Override
    public ChannelInfoDto findByOrderId(String orderId) {
        QihoChannelInfoEntity qihoChannelInfoEntity = qihoChannelInfoDAO.findByOrderId(orderId);
        ChannelInfoDto channelInfoDto = BeanUtils.copy(qihoChannelInfoEntity, ChannelInfoDto.class);
        if (qihoChannelInfoEntity != null){
            channelInfoDto.setDeviceId(qihoChannelInfoEntity.getDeviceId());
        }
        return channelInfoDto;
    }

    /**
     * @see com.qiho.center.biz.service.order.ChannelInfoService#updateByOrderId(com.qiho.center.api.dto.ChannelInfoDto)
     */
    @Override
    public int updateByOrderId(ChannelInfoDto channelInfo) {
        QihoChannelInfoEntity entity = BeanUtils.copy(channelInfo, QihoChannelInfoEntity.class);
        entity.setDeviceId(channelInfo.getDeviceId());
        return qihoChannelInfoDAO.updateByOrderId(entity);
    }

    @Override
    public List<ChannelInfoDto> findByOrderIds(List<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        List<QihoChannelInfoEntity> list = qihoChannelInfoDAO.findByOrderIds(ids);
        return BeanUtils.copyList(list,ChannelInfoDto.class);
    }

}

