package com.qiho.center.biz.service.impl.order;

import java.util.Calendar;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.enums.DeliveryRecordStateEnum;
import com.qiho.center.api.params.DeliveryRecordQueryParams;
import com.qiho.center.biz.service.order.OrderFileDeliveryService;
import com.qiho.center.biz.util.DeliveryRecordUtil;
import com.qiho.center.common.daoh.qiho.order.DeliveryRecordMapper;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;

/**
 * OrderFileDeliveryServiceImpl
 *
 * @Created by zhangshun on 2018-03-08 15:32:20
 */
@Service
public class OrderFileDeliveryServiceImpl implements OrderFileDeliveryService {

    @Resource
    private DeliveryRecordMapper deliveryRecordMapper;

    @Override
    public DeliveryRecordDto getJob() {

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.DATE, -3);

        DeliveryRecordQueryParams params = new DeliveryRecordQueryParams();
        params.setGmtCreateEnd(calendar.getTime());

        return DeliveryRecordUtil.entityToDto(deliveryRecordMapper.selectJob(params));
    }

    @Override
    public Boolean setStateRunning(Long id, int totalCount) {

        DeliveryRecordEntity record = new DeliveryRecordEntity();

        record.setId(id);
        record.setRemark("已开始");
        record.setTotalCount(totalCount);
        record.setState(DeliveryRecordStateEnum.RUNNING.getCode());

        if (0 < deliveryRecordMapper.updateByIdSelective(record)) {
            return Boolean.TRUE;
        }

        return Boolean.FALSE;
    }

    @Override
    public Boolean setStateError(Long id, String msg) {
        DeliveryRecordEntity record = new DeliveryRecordEntity();

        record.setId(id);
        record.setRemark(DeliveryRecordStateEnum.ERROR.getName() + ":" + msg);
        record.setState(DeliveryRecordStateEnum.ERROR.getCode());

        if (0 < deliveryRecordMapper.updateByIdSelective(record)) {
            return Boolean.TRUE;
        }

        return Boolean.FALSE;
    }

    @Override
    public Boolean updateByIdSelective(DeliveryRecordEntity entity) {
        if (0 < deliveryRecordMapper.updateByIdSelective(entity)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

}
