package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.*;
import com.qiho.center.biz.engine.impl.AheadPreventOrderEngine;
import com.qiho.center.biz.service.order.OrderStrategyCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/8/2.
 */
@Service
public class OrderStrategyCheckServiceImpl implements OrderStrategyCheckService {

	private static final Logger LOGGER = LoggerFactory.getLogger(OrderStrategyCheckServiceImpl.class);

	@Resource
	private AheadPreventOrderEngine  aheadPreventOrderEngine;

	@Override
	public StrategyCheckResultDto checkStrategyAheadOrder(OrderDto order, ChannelInfoDto channelInfo,
			String payType) {
		StrategyCheckResultDto result = new StrategyCheckResultDto();
		result.setSuccess(true);
		try {
			OrderSnapshotDto orderSnapshotDto = BeanUtils.copy(order,OrderSnapshotDto.class);
			//封装商品信息
			OrderItemDto orderItemDto = order.getOrderItem();
			orderSnapshotDto.setItemId(orderItemDto.getItemId());
			orderSnapshotDto.setItemName(orderItemDto.getItemName());
			orderSnapshotDto.setItemShortName(orderItemDto.getItemShortName());
			orderSnapshotDto.setItemNo(orderItemDto.getItemNo());
			orderSnapshotDto.setSellingPrice(orderItemDto.getSellingPrice());
			orderSnapshotDto.setOriginalPrice(orderItemDto.getOriginalPrice());
			orderSnapshotDto.setQuantity(orderItemDto.getQuantity());
			orderSnapshotDto.setSkuName(orderItemDto.getSkuName());
			orderSnapshotDto.setSkuNo(orderItemDto.getSkuNo());
			//渠道信息
			orderSnapshotDto.setChannelId(channelInfo.getChannelId());
			orderSnapshotDto.setCountChannelId(channelInfo.getCountChannelId());
			orderSnapshotDto.setUrl(channelInfo.getUrl());
			orderSnapshotDto.setIp(channelInfo.getIp());
			orderSnapshotDto.setUserAgent(channelInfo.getUserAgent());
			orderSnapshotDto.setTuiaId(order.getTuiaId());
			//设置支付方式
			orderSnapshotDto.setPayType(payType);

			result.setOrderSnapshotDto(orderSnapshotDto);
			return aheadPreventOrderEngine.process(result);
		} catch (Exception e) {
			//如果出现异常情况,则直接默认返回通过,不要影响下单流程
			//订单创建完成后,后续还有踢单流程可以进一步拦截处理
			LOGGER.error("下单规则异常，order = {}，channelInfo = {}", order, channelInfo, e);
			return result;
		}
	}
}
