package com.qiho.center.biz.service.logistics;

import com.google.common.collect.Lists;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.common.util.JDClientUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by weny.cai on 2017/10/26.
 */
@Component
public class JDQueryProcessor implements LogisticsQueryProcessor, InitializingBean {

    private static final Logger LOG               = LoggerFactory.getLogger(YtoQueryProcessor.class);

    private static final String SUCCESS_CODE = "0";

    @Autowired
    private JDClientUtil jdClientUtil;


    @Override
    public List<LogisticsProcessDto> queryWaybillTrace(String postId) {
        List<LogisticsProcessDto> list = Lists.newArrayList();
        if (StringUtils.isBlank(postId)) {
            return list;
        }
        try {
            LdopReceiveTraceGetResponse response = jdClientUtil.executeLdopReceiveTrace(postId);
            if (SUCCESS_CODE.equals(response.getCode())){
                List<TraceDTO> dtos = response.getQuerytraceResult().getData();
                for (int i = dtos.size()-1; i >= 0 ; i--) {
                    TraceDTO dto = dtos.get(i);
                    LogisticsProcessDto logisticsProcessDto = new LogisticsProcessDto();
                    logisticsProcessDto.setWaybillNo(dto.getWaybillCode());
                    logisticsProcessDto.setProcessInfo(dto.getOpeRemark());
                    logisticsProcessDto.setUploadTime(dto.getOpeTime());
                    list.add(logisticsProcessDto);
                }
            }
        } catch (JdException e) {
            LOG.warn("查询京东快递运单走件流程异常， postId = " + postId, e);
        }
        return list;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        LogisticsQueryDecider.registLogisticsQueryProcessor(LogisticsNameEnum.JD, this);
    }
}
