package com.qiho.center.biz.service.message;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageCheckedDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageCheckedPagingParams;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;


/**
 * @author: wangjin
 * @create 2018-07-02 15:30
 **/
public interface MessageService {

    /**
     * 保存新增消息
     * @param dto
     * @return
     */
    int saveMessage(MessageNotifyDto dto);

    /**
     * 保存发布消息
     * @param dto
     * @return
     */
    boolean saveAndPublishMessage(MessageNotifyDto dto);


    /**
     * 删除消息
     * @param id
     * @return
     */
    boolean deleteMessage(Long id);

    /**
     * 管理后台查看消息
     * @param id
     * @return
     */
    MessageNotifyDto findMessageById(Long id);

    /**
     * 管理后台 列表
     * @param params
     * @return
     */
    PagenationDto<MessageNotifyDto> findMessages(MessageNotifyPagingParams params);


    /**
     * 获取商家未读数量
     * @param merchantId
     * @return
     */
    int countCheckedMessage(Long merchantId);

    /**
     * 查询description
     * @param merchantId
     * @return
     */
    MessageNotifyDto findMessageDescription(Long merchantId);

    /**
     * 商家后台列表
     * @param params
     * @return
     */
    PagenationDto<MessageCheckedDto> findCheckedMessages(MessageCheckedPagingParams params);

    /**
     * 阅读消息
     * @param id
     * @param merchantId
     * @return
     */
    MessageNotifyDto readMessage(Long id,Long merchantId);





}
