/**
 * Project Name:qiho-center-biz
 * File Name:FundOrderService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月6日下午1:02:33
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import java.util.List;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;

/**
 * ClassName:FundOrderService <br/>
 * Date:     2017年6月6日 下午1:02:33 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface FundOrderService {

    /**
     * 根据订单ID查询资金流水
     *
     * @author zhanglihui
     * @param orderId
     * @return List<FundOrderDto>
     */
    List<FundOrderDto> findByOrderId(String orderId);

    /**
     * 分页查询资金流水
     * @author zhanglihui
     * @param param
     * @return PagenationDto<FundOrderDto>
     */
    PagenationDto<FundOrderDto> queryFundPage(FundPageParam param);

    /**
     * 根据订单ID和资金业务类型查询资金订单
     * @author zhanglihui
     * @param orderId 订单ID
     * @param bizType 资金业务类型
     * @return List<FundOrderDto>
     */
    List<FundOrderDto> findByOrderIdAndBizType(String orderId, String bizType);

    /**
     * 处理资金处理结果消息，更新主订单和资金订单状态，并且自动发起审批
     * @author zhanglihui
     * @param fundOrder          更新后的自定子订单
     * @param originalFundStatus 待更新资金订单状态，根据ID+状态保证幂等
     */
    void notifySuccess(FundOrderDto fundOrder, String originalFundStatus);

    /**
     * 
     * @author zhanglihui
     * @param orderId
     * @param payType
     * @param amt
     */
    void refund(String orderId, String payType, Integer amt);

    /**
     * 更新付款类型
     * @author zhanglihui
     * @param fundOrder 
     * @param originalFundStatus 
     */
    void updatePayType(FundOrderDto fundOrder, String originalFundStatus);

    /**
     * 更新资金订单
     * @param fundOrder
     */
    int update(FundOrderDto fundOrder);

    /**
     * 根据fundId和资金状态查找资金流水
     * @param fundId
     * @return
     */
    FundOrderDto findByFundId(String fundId);


    List<FundOrderDto> queryFundOrderToSync(FundPageParam param,Integer pageSize,Integer pageNo);
}

